/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeCachingCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.AbstractDataObjectCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.AugmentationCodecPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecContextFactory;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecContextSupplier;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecDataObject;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecDataObjectGenerator;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecItemFactory;
import org.opendaylight.mdsal.binding.dom.codec.impl.CommonDataObjectCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.CommonDataObjectCodecPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerAnalysis;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerPrototype;
import org.opendaylight.mdsal.binding.loader.BindingClassLoader;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.runtime.api.AugmentRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.AugmentableRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.api.CompositeRuntimeType;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.BindingObject;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.DataObjectStep;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.builder.DataContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.spi.node.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Beta
public abstract class DataObjectCodecContext<D extends DataObject, T extends CompositeRuntimeType>
extends AbstractDataObjectCodecContext<D, T>
implements BindingDataObjectCodecTreeNode<D> {
    private static final Logger LOG = LoggerFactory.getLogger(DataObjectCodecContext.class);
    private static final MethodType CONSTRUCTOR_TYPE = MethodType.methodType(Void.TYPE, AbstractDataObjectCodecContext.class, DataContainerNode.class);
    private static final MethodType DATAOBJECT_TYPE = MethodType.methodType(DataObject.class, DataObjectCodecContext.class, DataContainerNode.class);
    private static final VarHandle MISMATCHED_AUGMENTED;
    private final ImmutableMap<Class<?>, AugmentationCodecPrototype<?>> augmentToPrototype;
    private final ImmutableMap<YangInstanceIdentifier.NodeIdentifier, Class<?>> yangToAugmentClass;
    private final @NonNull Class<? extends CodecDataObject<?>> generatedClass;
    private final MethodHandle proxyConstructor;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"}, justification="https://github.com/spotbugs/spotbugs/issues/2749")
    private volatile ImmutableMap<Class<?>, CommonDataObjectCodecPrototype<?>> mismatchedAugmented = ImmutableMap.of();

    DataObjectCodecContext(CommonDataObjectCodecPrototype<T> prototype) {
        this(prototype, CodecItemFactory.of());
    }

    DataObjectCodecContext(CommonDataObjectCodecPrototype<T> prototype, CodecItemFactory itemFactory) {
        this(prototype, new DataContainerAnalysis<T>(prototype, itemFactory), null);
    }

    DataObjectCodecContext(CommonDataObjectCodecPrototype<T> prototype, Method keyMethod) {
        this(prototype, new DataContainerAnalysis<T>(prototype, CodecItemFactory.of()), keyMethod);
    }

    private DataObjectCodecContext(CommonDataObjectCodecPrototype<T> prototype, DataContainerAnalysis<T> analysis, Method keyMethod) {
        super(prototype, analysis);
        MethodHandle ctor;
        List possibleAugmentations;
        Class bindingClass = this.getBindingClass();
        BindingClassLoader loader = ((CommonDataObjectCodecPrototype)this.prototype()).contextFactory().getLoader();
        if (Augmentable.class.isAssignableFrom(bindingClass)) {
            Object runtimeType = prototype.runtimeType();
            if (!(runtimeType instanceof AugmentableRuntimeType)) {
                throw new VerifyException("Unexpected type %s backing augmenable %s".formatted(runtimeType, bindingClass));
            }
            AugmentableRuntimeType augmentableRuntimeType = (AugmentableRuntimeType)runtimeType;
            possibleAugmentations = augmentableRuntimeType.augments();
            this.generatedClass = CodecDataObjectGenerator.generateAugmentable(loader, bindingClass, analysis.leafContexts, analysis.daoProperties, keyMethod);
        } else {
            possibleAugmentations = List.of();
            this.generatedClass = CodecDataObjectGenerator.generate(loader, bindingClass, analysis.leafContexts, analysis.daoProperties, keyMethod);
        }
        try {
            ctor = MethodHandles.publicLookup().findConstructor(this.generatedClass, CONSTRUCTOR_TYPE);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new LinkageError("Failed to find contructor for class " + this.generatedClass, e);
        }
        this.proxyConstructor = ctor.asType(DATAOBJECT_TYPE);
        HashMap<YangInstanceIdentifier.NodeIdentifier, Class<DataObject>> augPathToBinding = new HashMap<YangInstanceIdentifier.NodeIdentifier, Class<DataObject>>();
        HashMap augClassToProto = new HashMap();
        for (AugmentRuntimeType augment : possibleAugmentations) {
            AugmentationCodecPrototype<?> augProto = this.loadAugmentPrototype(augment);
            if (augProto == null) continue;
            Class<DataObject> augBindingClass = augProto.javaClass();
            for (YangInstanceIdentifier.NodeIdentifier childPath : augProto.getChildArgs()) {
                augPathToBinding.putIfAbsent(childPath, augBindingClass);
            }
            augClassToProto.putIfAbsent(augBindingClass, augProto);
        }
        this.yangToAugmentClass = ImmutableMap.copyOf(augPathToBinding);
        this.augmentToPrototype = ImmutableMap.copyOf(augClassToProto);
    }

    @Override
    final DataContainerPrototype<?, ?> pathChildPrototype(Class<? extends DataObject> argType) {
        DataContainerPrototype child = super.pathChildPrototype(argType);
        return child != null ? child : (DataContainerPrototype)this.augmentToPrototype.get(argType);
    }

    @Override
    final DataContainerPrototype<?, ?> streamChildPrototype(Class<?> childClass) {
        DataContainerPrototype<?, ?> child = super.streamChildPrototype(childClass);
        if (child == null && Augmentation.class.isAssignableFrom(childClass)) {
            return this.getAugmentationProtoByClass(childClass);
        }
        return child;
    }

    @Override
    final CodecContextSupplier yangChildSupplier(YangInstanceIdentifier.NodeIdentifier arg) {
        Class augClass;
        CodecContextSupplier child = super.yangChildSupplier(arg);
        if (child == null && (augClass = (Class)this.yangToAugmentClass.get((Object)arg)) != null) {
            return (CodecContextSupplier)this.augmentToPrototype.get((Object)augClass);
        }
        return child;
    }

    private @Nullable AugmentationCodecPrototype<?> getAugmentationProtoByClass(@NonNull Class<?> augmClass) {
        AugmentationCodecPrototype<?> childProto = (AugmentationCodecPrototype<?>)this.augmentToPrototype.get(augmClass);
        return childProto != null ? childProto : this.mismatchedAugmentationByClass(augmClass);
    }

    private @Nullable AugmentationCodecPrototype<?> mismatchedAugmentationByClass(@NonNull Class<?> childClass) {
        ImmutableMap local = MISMATCHED_AUGMENTED.getAcquire(this);
        AugmentationCodecPrototype<?> mismatched = (AugmentationCodecPrototype<?>)local.get(childClass);
        return mismatched != null ? mismatched : this.loadMismatchedAugmentation(local, childClass);
    }

    private @Nullable AugmentationCodecPrototype<?> loadMismatchedAugmentation(ImmutableMap<Class<?>, AugmentationCodecPrototype<?>> oldMismatched, @NonNull Class<?> childClass) {
        Class<Augmentable<?>> augTarget = DataObjectCodecContext.findAugmentationTarget(childClass);
        if (this.getBindingClass().equals(augTarget) && this.belongsToRuntimeContext(childClass)) {
            for (AugmentationCodecPrototype realChild : this.augmentToPrototype.values()) {
                Class<DataObject> realClass = realChild.javaClass();
                if (!Augmentation.class.isAssignableFrom(realClass) || !DataObjectCodecContext.isSubstitutionFor(childClass, realClass)) continue;
                return this.cacheMismatched(oldMismatched, childClass, realChild);
            }
        }
        LOG.trace("Failed to resolve {} as a valid augmentation in {}", childClass, (Object)this);
        return null;
    }

    private @NonNull AugmentationCodecPrototype<?> cacheMismatched(@NonNull ImmutableMap<Class<?>, AugmentationCodecPrototype<?>> oldMismatched, @NonNull Class<?> childClass, @NonNull AugmentationCodecPrototype<?> prototype) {
        ImmutableMap witness;
        AugmentationCodecPrototype existing;
        ImmutableMap expected = oldMismatched;
        do {
            ImmutableMap newMismatched;
            if ((witness = MISMATCHED_AUGMENTED.compareAndExchangeRelease(this, expected, newMismatched = ImmutableMap.builderWithExpectedSize((int)(expected.size() + 1)).putAll(expected).put(childClass, prototype).build())) != expected) continue;
            LOG.trace("Cached mismatched augmentation {} -> {} in {}", new Object[]{childClass, prototype, this});
            return prototype;
        } while ((existing = (AugmentationCodecPrototype)(expected = witness).get(childClass)) == null);
        LOG.trace("Using raced mismatched augmentation {} -> {} in {}", new Object[]{childClass, existing, this});
        return existing;
    }

    private boolean belongsToRuntimeContext(Class<?> cls) {
        Class loaded;
        BindingRuntimeContext ctx = ((CommonDataObjectCodecPrototype)this.prototype()).contextFactory().getRuntimeContext();
        try {
            loaded = ctx.loadClass(Type.of(cls));
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Proposed {} cannot be loaded in {}", new Object[]{cls, ctx, e});
            return false;
        }
        return cls.equals(loaded);
    }

    private @Nullable AugmentationCodecPrototype<?> loadAugmentPrototype(AugmentRuntimeType augment) {
        Class augClass;
        ImmutableSet childPaths = (ImmutableSet)augment.statement().streamEffectiveSubstatements(SchemaTreeEffectiveStatement.class).map(stmt -> new YangInstanceIdentifier.NodeIdentifier((QName)stmt.argument())).collect(ImmutableSet.toImmutableSet());
        if (childPaths.isEmpty()) {
            return null;
        }
        CodecContextFactory factory = ((CommonDataObjectCodecPrototype)this.prototype()).contextFactory();
        GeneratedType javaType = augment.javaType();
        try {
            augClass = factory.getRuntimeContext().loadClass((Type)javaType);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("RuntimeContext references type " + javaType + " but failed to load its class", e);
        }
        return new AugmentationCodecPrototype(augClass, augment, factory, (ImmutableSet<YangInstanceIdentifier.NodeIdentifier>)childPaths);
    }

    @Override
    Map<Class<? extends Augmentation<?>>, Augmentation<?>> getAllAugmentationsFrom(DataContainerNode data) {
        HashMap<Class, DataContainerNodeBuilder> builders = new HashMap<Class, DataContainerNodeBuilder>();
        for (DataContainerChild childValue : data.body()) {
            Class bindingClass = (Class)this.yangToAugmentClass.get((Object)childValue.name());
            if (bindingClass == null) continue;
            builders.computeIfAbsent(bindingClass, key -> ImmutableNodes.newContainerBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(data.name().getNodeType()))).addChild((NormalizedNode)childValue);
        }
        HashMap map = new HashMap();
        for (Map.Entry entry : builders.entrySet()) {
            Object bindingObj;
            Class bindingClass = (Class)entry.getKey();
            AugmentationCodecPrototype codecProto = (AugmentationCodecPrototype)this.augmentToPrototype.get((Object)bindingClass);
            if (codecProto == null || (bindingObj = ((CommonDataObjectCodecContext)codecProto.getCodecContext()).deserializeObject(((DataContainerNodeBuilder)entry.getValue()).build())) == null) continue;
            map.put(bindingClass, (Augmentation<?>)bindingObj);
        }
        return map;
    }

    public DataObjectStep<?> deserializePathArgument(YangInstanceIdentifier.PathArgument arg) {
        Preconditions.checkArgument((boolean)this.getDomPathArgument().equals((Object)arg));
        return this.bindingArg();
    }

    public YangInstanceIdentifier.PathArgument serializePathArgument(DataObjectStep<?> step) {
        Preconditions.checkArgument((boolean)this.bindingArg().equals(step));
        return this.getDomPathArgument();
    }

    public NormalizedNode serialize(D data) {
        return this.serializeImpl(data);
    }

    public final BindingNormalizedNodeCachingCodec<D> createCachingCodec(ImmutableCollection<Class<? extends BindingObject>> cacheSpecifier) {
        return DataObjectCodecContext.createCachingCodec(this, cacheSpecifier);
    }

    final @NonNull Class<? extends CodecDataObject<?>> generatedClass() {
        return this.generatedClass;
    }

    final @NonNull D createBindingProxy(DataContainerNode node) {
        try {
            return (D)this.proxyConstructor.invokeExact(this, node);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    Object deserializeObject(NormalizedNode normalizedNode) {
        return this.deserialize(normalizedNode);
    }

    static {
        try {
            MISMATCHED_AUGMENTED = MethodHandles.lookup().findVarHandle(DataObjectCodecContext.class, "mismatchedAugmented", ImmutableMap.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

