/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.UnaryOperator;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.impl.ListCodecContext;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LazyBindingList<E extends DataObject>
extends AbstractList<E>
implements Immutable,
RandomAccess {
    static final VarHandle OBJ_AA = MethodHandles.arrayElementVarHandle(Object[].class);
    private static final Logger LOG = LoggerFactory.getLogger(LazyBindingList.class);
    private static final String LAZY_CUTOFF_PROPERTY = "org.opendaylight.mdsal.binding.dom.codec.impl.LazyBindingList.max-eager-elements";
    private static final int DEFAULT_LAZY_CUTOFF = 16;
    @VisibleForTesting
    static final int LAZY_CUTOFF;
    private final ListCodecContext<E> codec;
    private final Object[] objects;

    private LazyBindingList(ListCodecContext<E> codec, Collection<? extends NormalizedNodeContainer<?>> entries) {
        this.codec = Objects.requireNonNull(codec);
        this.objects = entries.toArray();
    }

    static <E extends DataObject> @NonNull List<E> of(ListCodecContext<E> codec, int size, Collection<? extends DataContainerNode> entries) {
        if (size == 1) {
            return List.of(codec.createBindingProxy(entries.iterator().next()));
        }
        return size > LAZY_CUTOFF ? new LazyBindingList<E>(codec, entries) : LazyBindingList.eagerList(codec, size, entries);
    }

    private static <E extends DataObject> @NonNull List<E> eagerList(ListCodecContext<E> codec, int size, Collection<? extends DataContainerNode> entries) {
        DataObject[] objs = new DataObject[size];
        int offset = 0;
        for (DataContainerNode dataContainerNode : entries) {
            objs[offset++] = codec.createBindingProxy(dataContainerNode);
        }
        Verify.verify((offset == objs.length ? 1 : 0) != 0);
        return List.of(objs);
    }

    @Override
    public int size() {
        return this.objects.length;
    }

    @Override
    public E get(int index) {
        Object obj = OBJ_AA.getAcquire(this.objects, index);
        return (E)(obj.getClass() == this.codec.generatedClass() ? (DataObject)obj : this.load(index, (DataContainerNode)obj));
    }

    private @NonNull E load(int index, DataContainerNode node) {
        Object ret = this.codec.createBindingProxy(node);
        Object witness = OBJ_AA.compareAndExchangeRelease(this.objects, index, node, (DataObject)ret);
        return (E)(witness == node ? ret : (DataObject)witness);
    }

    @Override
    public boolean remove(Object o) {
        throw LazyBindingList.uoe();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw LazyBindingList.uoe();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw LazyBindingList.uoe();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw LazyBindingList.uoe();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw LazyBindingList.uoe();
    }

    @Override
    public void sort(Comparator<? super E> c) {
        throw LazyBindingList.uoe();
    }

    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        throw LazyBindingList.uoe();
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        throw LazyBindingList.uoe();
    }

    private static UnsupportedOperationException uoe() {
        return new UnsupportedOperationException("Modification not supported");
    }

    static {
        int value = Integer.getInteger(LAZY_CUTOFF_PROPERTY, 16);
        if (value < 0) {
            LOG.info("Lazy population of lists disabled");
            LAZY_CUTOFF = Integer.MAX_VALUE;
        } else {
            LOG.info("Using lazy population for lists larger than {} element(s)", (Object)value);
            LAZY_CUTOFF = value;
        }
    }
}

