/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Objects;
import org.opendaylight.mdsal.binding.dom.codec.impl.EncapsulatedValueCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.ValueCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UnionValueOptionContext {
    private static final MethodType OBJECT_TYPE = MethodType.methodType(Object.class, Object.class);
    private static final Logger LOG = LoggerFactory.getLogger(UnionValueOptionContext.class);
    private final Class<?> bindingType;
    private final ValueCodec<Object, Object> codec;
    private final MethodHandle getter;
    private final MethodHandle unionCtor;

    UnionValueOptionContext(Class<?> unionType, Class<?> valueType, Method getter, ValueCodec<Object, Object> codec) {
        this.bindingType = Objects.requireNonNull(valueType);
        this.codec = Objects.requireNonNull(codec);
        try {
            this.getter = MethodHandles.publicLookup().unreflect(getter).asType(OBJECT_TYPE);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Failed to access method " + getter, e);
        }
        try {
            this.unionCtor = MethodHandles.publicLookup().findConstructor(unionType, MethodType.methodType(Void.TYPE, valueType)).asType(OBJECT_TYPE);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalStateException(String.format("Failed to access constructor for %s in type %s", valueType, unionType), e);
        }
    }

    Object serialize(Object input) {
        Object baValue = this.getValueFrom(input);
        return baValue == null ? null : this.codec.serialize(baValue);
    }

    Object deserializeUnion(Object input) {
        Object value;
        if (this.codec instanceof EncapsulatedValueCodec && !((EncapsulatedValueCodec)this.codec).canAcceptObject(input)) {
            return null;
        }
        try {
            value = this.codec.deserialize(input);
        }
        catch (Exception e) {
            LOG.debug("Codec {} failed to deserialize input {}", new Object[]{this.codec, input, e});
            return null;
        }
        try {
            return this.unionCtor.invokeExact(value);
        }
        catch (ClassCastException e) {
            LOG.debug("Failed to instantiate {} for input {} value {}", new Object[]{this.bindingType, input, value, e});
            return null;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Failed to construct union for value " + value, e);
        }
    }

    Object getValueFrom(Object input) {
        try {
            return this.getter.invokeExact(input);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public int hashCode() {
        return this.bindingType.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UnionValueOptionContext)) {
            return false;
        }
        UnionValueOptionContext other = (UnionValueOptionContext)obj;
        return this.bindingType.equals(other.bindingType);
    }
}

