/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecContextSupplier;
import org.opendaylight.mdsal.binding.dom.codec.impl.ValueCodec;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class ValueNodeCodecContext
extends CodecContext
implements CodecContextSupplier {
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifier yangIdentifier;
    private final @NonNull DataSchemaNode dataSchema;
    private final @NonNull String getterName;
    private final Object defaultObject;

    ValueNodeCodecContext(DataSchemaNode dataSchema, String getterName, Object defaultObject) {
        this.getterName = Objects.requireNonNull(getterName);
        this.dataSchema = Objects.requireNonNull(dataSchema);
        this.yangIdentifier = YangInstanceIdentifier.NodeIdentifier.create((QName)dataSchema.getQName());
        this.defaultObject = defaultObject;
    }

    @Override
    final YangInstanceIdentifier.NodeIdentifier getDomPathArgument() {
        return this.yangIdentifier;
    }

    @Override
    public final CodecContext getCodecContext() {
        return this;
    }

    final String getGetterName() {
        return this.getterName;
    }

    abstract ValueCodec<Object, Object> getValueCodec();

    @Deprecated(since="13.0.0", forRemoval=true)
    public final DataSchemaNode getSchema() {
        return this.dataSchema;
    }

    @Override
    final Object defaultObject() {
        return this.defaultObject;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static abstract class WithCodec
    extends ValueNodeCodecContext {
        private final @NonNull ValueCodec<Object, Object> valueCodec;

        WithCodec(DataSchemaNode schema, ValueCodec<Object, Object> codec, String getterName, Object defaultObject) {
            super(schema, getterName, defaultObject);
            this.valueCodec = Objects.requireNonNull(codec);
        }

        @Override
        final ValueCodec<Object, Object> getValueCodec() {
            return this.valueCodec;
        }
    }
}

