/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.generator.impl.reactor;

import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractAugmentGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.AugmentResolver;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CompositeRuntimeTypeBuilder;
import org.opendaylight.mdsal.binding.generator.impl.reactor.CompositeSchemaTreeGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.mdsal.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.mdsal.binding.generator.impl.rt.DefaultChoiceRuntimeType;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.AnnotableTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.mdsal.binding.model.ri.BindingTypes;
import org.opendaylight.mdsal.binding.runtime.api.AugmentRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.CaseRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.ChoiceRuntimeType;
import org.opendaylight.mdsal.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

final class ChoiceGenerator
extends CompositeSchemaTreeGenerator<ChoiceEffectiveStatement, ChoiceRuntimeType> {
    ChoiceGenerator(ChoiceEffectiveStatement statement, AbstractCompositeGenerator<?, ?> parent) {
        super(statement, parent);
    }

    @Override
    void pushToInference(SchemaInferenceStack dataTree) {
    }

    @Override
    GeneratedType createTypeImpl(TypeBuilderFactory builderFactory) {
        GeneratedTypeBuilder builder = builderFactory.newGeneratedTypeBuilder(this.typeName());
        builder.addImplementsType((Type)BindingTypes.choiceIn((Type)Type.of((JavaTypeName)this.getParent().typeName())));
        ModuleGenerator module = this.currentModule();
        module.addQNameConstant((GeneratedTypeBuilderBase<?>)builder, this.localName());
        this.annotateDeprecatedIfNecessary((AnnotableTypeBuilder)builder);
        builderFactory.addCodegenInformation(module, (EffectiveStatement<?, ?>)this.statement(), (GeneratedTypeBuilderBase<?>)builder);
        builder.setModuleName(((UnresolvedQName.Unqualified)((ModuleEffectiveStatement)module.statement()).argument()).getLocalName());
        return builder.build();
    }

    ChoiceBuilder createBuilder(ChoiceEffectiveStatement statement) {
        return new ChoiceBuilder(statement);
    }

    static final class ChoiceBuilder
    extends CompositeRuntimeTypeBuilder<ChoiceEffectiveStatement, ChoiceRuntimeType> {
        private final List<CaseRuntimeType> augmentedCases = new ArrayList<CaseRuntimeType>();

        ChoiceBuilder(ChoiceEffectiveStatement statement) {
            super(statement);
        }

        @Override
        void processAugment(AugmentResolver resolver, AbstractAugmentGenerator augment) {
            augment.fillRuntimeCasesIn(resolver, (ChoiceEffectiveStatement)this.statement(), this.augmentedCases);
        }

        @Override
        boolean isAugmentedChild(QName qname) {
            for (CaseRuntimeType augmented : this.augmentedCases) {
                if (!qname.equals(augmented.statement().argument())) continue;
                return true;
            }
            return false;
        }

        @Override
        ChoiceRuntimeType build(GeneratedType type, ChoiceEffectiveStatement statement, List<RuntimeType> children, List<AugmentRuntimeType> augments) {
            Verify.verify((boolean)augments.isEmpty(), (String)"Unexpected augments %s", augments);
            children.addAll(this.augmentedCases);
            return new DefaultChoiceRuntimeType(type, statement, children);
        }
    }
}

