/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.java.api.generator;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.java.api.generator.NestedJavaGeneratedType;
import org.opendaylight.mdsal.binding.model.api.Enumeration;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.ParameterizedType;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.WildcardType;

@NonNullByDefault
abstract class AbstractJavaGeneratedType {
    private final Map<JavaTypeName, @Nullable String> nameCache = new HashMap<JavaTypeName, String>();
    private final ImmutableMap<String, NestedJavaGeneratedType> enclosedTypes;
    private final ImmutableSet<String> conflictingNames;
    private final JavaTypeName name;

    AbstractJavaGeneratedType(GeneratedType genType) {
        this.name = (JavaTypeName)genType.getIdentifier();
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (GeneratedType type : Iterables.concat((Iterable)genType.getEnclosedTypes(), (Iterable)genType.getEnumerations())) {
            b.put((Object)((JavaTypeName)type.getIdentifier()).simpleName(), (Object)new NestedJavaGeneratedType(this, type));
        }
        this.enclosedTypes = b.build();
        HashSet<String> cb = new HashSet<String>();
        if (genType instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)genType;
            enumeration.getValues().stream().map(Enumeration.Pair::getMappedName).forEach(cb::add);
        }
        this.collectAccessibleTypes(cb, genType);
        this.conflictingNames = ImmutableSet.copyOf(cb);
    }

    private void collectAccessibleTypes(Set<String> set, GeneratedType type) {
        for (Type impl : type.getImplements()) {
            if (!(impl instanceof GeneratedType)) continue;
            GeneratedType genType = (GeneratedType)impl;
            for (GeneratedType inner : Iterables.concat((Iterable)genType.getEnclosedTypes(), (Iterable)genType.getEnumerations())) {
                set.add(((JavaTypeName)inner.getIdentifier()).simpleName());
            }
            this.collectAccessibleTypes(set, genType);
        }
    }

    final JavaTypeName getName() {
        return this.name;
    }

    final String getSimpleName() {
        return this.name.simpleName();
    }

    private String annotateReference(String ref, Type type, String annotation) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)type;
            return this.getReferenceString(AbstractJavaGeneratedType.annotate(ref, annotation), type, parameterized.getActualTypeArguments());
        }
        return "byte[]".equals(ref) ? "byte @" + annotation + "[]" : AbstractJavaGeneratedType.annotate(ref, annotation).toString();
    }

    final String getFullyQualifiedReference(Type type, String annotation) {
        return this.annotateReference(type.getFullyQualifiedName(), type, annotation);
    }

    final String getReferenceString(Type type) {
        String string;
        String ref = this.getReferenceString((JavaTypeName)type.getIdentifier());
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)type;
            string = this.getReferenceString(new StringBuilder(ref), type, parameterized.getActualTypeArguments());
        } else {
            string = ref;
        }
        return string;
    }

    final String getReferenceString(Type type, String annotation) {
        String ref = this.getReferenceString((JavaTypeName)type.getIdentifier());
        return this.annotateReference(ref, type, annotation);
    }

    private String getReferenceString(StringBuilder sb, Type type, @NonNull Type[] arguments) {
        if (arguments.length == 0) {
            return sb.append("<?>").toString();
        }
        sb.append('<');
        for (int i = 0; i < arguments.length; ++i) {
            Type arg = arguments[i];
            if (arg instanceof WildcardType) {
                sb.append("? extends ");
            }
            sb.append(this.getReferenceString(arg));
            if (i == arguments.length - 1) continue;
            sb.append(", ");
        }
        return sb.append('>').toString();
    }

    final String getReferenceString(JavaTypeName type) {
        if (type.packageName().isEmpty()) {
            return type.simpleName();
        }
        if (this.name.equals((Object)type)) {
            return this.name.simpleName();
        }
        String existing = this.nameCache.get(type);
        if (existing != null) {
            return existing;
        }
        String result = this.name.topLevelClass().equals((Object)type.topLevelClass()) ? this.localTypeName(type) : (this.name.packageName().equals(type.packageName()) ? this.packageTypeName(type) : this.foreignTypeName(type));
        this.nameCache.put(type, result);
        return result;
    }

    final NestedJavaGeneratedType getEnclosedType(JavaTypeName type) {
        return Objects.requireNonNull((NestedJavaGeneratedType)this.enclosedTypes.get((Object)type.simpleName()));
    }

    final boolean checkAndImportType(JavaTypeName type) {
        String simpleName = type.simpleName();
        return !simpleName.equals(this.getSimpleName()) && !this.enclosedTypes.containsKey((Object)simpleName) && !this.conflictingNames.contains((Object)simpleName) && this.importCheckedType(type);
    }

    abstract boolean importCheckedType(JavaTypeName var1);

    abstract String localTypeName(JavaTypeName var1);

    private String foreignTypeName(JavaTypeName type) {
        return this.checkAndImportType(type) ? type.simpleName() : type.toString();
    }

    private String packageTypeName(JavaTypeName type) {
        return this.checkAndImportType(type.topLevelClass()) ? type.localName() : type.toString();
    }

    private static StringBuilder annotate(String ref, String annotation) {
        StringBuilder sb = new StringBuilder();
        int dot = ref.lastIndexOf(46);
        if (dot != -1) {
            sb.append(ref, 0, dot + 1);
        }
        return sb.append('@').append(annotation).append(' ').append(ref, dot + 1, ref.length());
    }
}

