/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.java.api.generator;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.java.api.generator.AbstractRangeGenerator;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractPrimitiveRangeGenerator<T extends Number>
extends AbstractRangeGenerator<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPrimitiveRangeGenerator.class);
    private final @NonNull String primitiveName;
    private final @NonNull T minValue;
    private final @NonNull T maxValue;

    AbstractPrimitiveRangeGenerator(Class<T> typeClass, String primitiveName, T minValue, T maxValue) {
        super(typeClass);
        this.primitiveName = Objects.requireNonNull(primitiveName);
        this.minValue = (Number)Objects.requireNonNull(minValue);
        this.maxValue = (Number)Objects.requireNonNull(maxValue);
    }

    protected final @NonNull String getPrimitiveName() {
        return this.primitiveName;
    }

    private boolean needsMaximumEnforcement(T maxToEnforce) {
        return ((Comparable)this.maxValue).compareTo(maxToEnforce) > 0;
    }

    private boolean needsMinimumEnforcement(T minToEnforce) {
        return ((Comparable)this.minValue).compareTo(minToEnforce) < 0;
    }

    private Collection<String> createExpressions(RangeConstraint<?> constraint, Function<Class<?>, String> classImporter) {
        Set constraints = constraint.getAllowedRanges().asRanges();
        ArrayList<String> ret = new ArrayList<String>(constraints.size());
        for (Range r : constraints) {
            Object min = this.getValue((Number)((Object)r.lowerEndpoint()));
            boolean needMin = this.needsMinimumEnforcement(min);
            Object max = this.getValue((Number)((Object)r.upperEndpoint()));
            boolean needMax = this.needsMaximumEnforcement(max);
            if (!needMin && !needMax) {
                LOG.debug("Type {} indicates [{}, {}] does not require enforcement", new Object[]{this.getTypeName(), min, max});
                continue;
            }
            StringBuilder sb = new StringBuilder();
            if (needMin) {
                this.appendMinCheck(sb, min, classImporter);
            }
            if (needMax) {
                if (needMin) {
                    sb.append(" && ");
                }
                this.appendMaxCheck(sb, max, classImporter);
            }
            ret.add(sb.toString());
        }
        return ret;
    }

    void appendMaxCheck(StringBuilder sb, T max, Function<Class<?>, String> classImporter) {
        sb.append("value <= ").append(this.format(max));
    }

    void appendMinCheck(StringBuilder sb, T min, Function<Class<?>, String> classImporter) {
        sb.append("value >= ").append(this.format(min));
    }

    protected abstract @NonNull String format(T var1);

    String codeHelpersThrow() {
        return "throwInvalidRange";
    }

    private String createRangeString(RangeConstraint<?> constraint) {
        Set constraints = constraint.getAllowedRanges().asRanges();
        ArrayList<Range> ranges = new ArrayList<Range>(constraints.size());
        for (Range c : constraints) {
            ranges.add(Range.closed(this.getValue((Number)((Object)c.lowerEndpoint())), this.getValue((Number)((Object)c.upperEndpoint()))));
        }
        return ((Object)ranges).toString();
    }

    @Override
    protected final String generateRangeCheckerImplementation(String checkerName, RangeConstraint<?> constraints, Function<Class<?>, String> classImporter) {
        StringBuilder sb = new StringBuilder();
        Collection<String> expressions = this.createExpressions(constraints, classImporter);
        sb.append("private static void ").append(checkerName).append("(final ").append(this.primitiveName).append(" value) {\n");
        if (!expressions.isEmpty()) {
            for (String exp : expressions) {
                sb.append("    if (").append(exp).append(") {\n");
                sb.append("        return;\n");
                sb.append("    }\n");
            }
            sb.append("    ").append(classImporter.apply(CodeHelpers.class)).append('.').append(this.codeHelpersThrow()).append("(\"").append(this.createRangeString(constraints)).append("\", value);\n");
        }
        return sb.append("}\n").toString();
    }
}

