/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.java.api.generator;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.java.api.generator.ByteRangeGenerator;
import org.opendaylight.mdsal.binding.java.api.generator.Decimal64RangeGenerator;
import org.opendaylight.mdsal.binding.java.api.generator.IntegerRangeGenerator;
import org.opendaylight.mdsal.binding.java.api.generator.JavaFileTemplate;
import org.opendaylight.mdsal.binding.java.api.generator.LongRangeGenerator;
import org.opendaylight.mdsal.binding.java.api.generator.ShortRangeGenerator;
import org.opendaylight.mdsal.binding.java.api.generator.TypeUtils;
import org.opendaylight.mdsal.binding.java.api.generator.Uint16RangeGenerator;
import org.opendaylight.mdsal.binding.java.api.generator.Uint32RangeGenerator;
import org.opendaylight.mdsal.binding.java.api.generator.Uint64RangeGenerator;
import org.opendaylight.mdsal.binding.java.api.generator.Uint8RangeGenerator;
import org.opendaylight.mdsal.binding.model.api.ConcreteType;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractRangeGenerator<T extends Number> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRangeGenerator.class);
    private static final ImmutableMap<String, AbstractRangeGenerator<?>> GENERATORS;
    private final @NonNull Class<T> type;

    private static void addGenerator(ImmutableMap.Builder<String, AbstractRangeGenerator<?>> builder, AbstractRangeGenerator<?> generator) {
        builder.put((Object)generator.getTypeClass().getCanonicalName(), generator);
    }

    protected AbstractRangeGenerator(Class<T> typeClass) {
        this.type = Objects.requireNonNull(typeClass);
    }

    static @NonNull AbstractRangeGenerator<?> forType(@NonNull Type type) {
        ConcreteType javaType = TypeUtils.getBaseYangType(type);
        return AbstractRangeGenerator.forName(javaType.getFullyQualifiedName());
    }

    private static @NonNull AbstractRangeGenerator<?> forName(String fqcn) {
        return (AbstractRangeGenerator)Verify.verifyNotNull((Object)((AbstractRangeGenerator)GENERATORS.get((Object)fqcn)), (String)"Unhandled type %s", (Object[])new Object[]{fqcn});
    }

    protected final @NonNull Class<T> getTypeClass() {
        return this.type;
    }

    protected final @NonNull String getTypeName() {
        return this.type.getName();
    }

    protected final @NonNull T getValue(Number value) {
        if (this.type.isInstance(value)) {
            return (T)((Number)this.type.cast(value));
        }
        LOG.debug("Converting value {} from {} to {}", new Object[]{value, value.getClass(), this.type});
        T ret = this.convert(value);
        AbstractRangeGenerator<?> gen = AbstractRangeGenerator.forName(value.getClass().getName());
        Object check = gen.convert((Number)ret);
        if (!value.equals(check)) {
            LOG.warn("Number class conversion from {} to {} truncated value {} to {}", new Object[]{value.getClass(), this.type, value, ret});
        }
        return ret;
    }

    @Deprecated
    protected abstract T convert(Number var1);

    protected abstract @NonNull String generateRangeCheckerImplementation(@NonNull String var1, @NonNull RangeConstraint<?> var2, Function<Class<?>, String> var3);

    private static @NonNull String rangeCheckerName(String member) {
        return "check" + member + "Range";
    }

    String generateRangeChecker(@NonNull String member, @NonNull RangeConstraint<?> constraints, JavaFileTemplate template) {
        return this.generateRangeCheckerImplementation(AbstractRangeGenerator.rangeCheckerName(member), constraints, template::importedName);
    }

    String generateRangeCheckerCall(@NonNull String member, @NonNull String valueReference) {
        return AbstractRangeGenerator.rangeCheckerName(member) + "(" + valueReference + this.primitiveRef() + ");\n";
    }

    String primitiveRef() {
        return "";
    }

    static {
        ImmutableMap.Builder b = ImmutableMap.builder();
        AbstractRangeGenerator.addGenerator(b, new ByteRangeGenerator());
        AbstractRangeGenerator.addGenerator(b, new ShortRangeGenerator());
        AbstractRangeGenerator.addGenerator(b, new IntegerRangeGenerator());
        AbstractRangeGenerator.addGenerator(b, new LongRangeGenerator());
        AbstractRangeGenerator.addGenerator(b, new Decimal64RangeGenerator());
        AbstractRangeGenerator.addGenerator(b, new Uint8RangeGenerator());
        AbstractRangeGenerator.addGenerator(b, new Uint16RangeGenerator());
        AbstractRangeGenerator.addGenerator(b, new Uint32RangeGenerator());
        AbstractRangeGenerator.addGenerator(b, new Uint64RangeGenerator());
        GENERATORS = b.build();
    }
}

