/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.java.api.generator;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.opendaylight.mdsal.binding.java.api.generator.AbstractBuilderTemplate;
import org.opendaylight.mdsal.binding.java.api.generator.BuilderGeneratedProperty;
import org.opendaylight.mdsal.binding.java.api.generator.BuilderTemplate;
import org.opendaylight.mdsal.binding.java.api.generator.GeneratorUtil;
import org.opendaylight.mdsal.binding.java.api.generator.JavaFileTemplate;
import org.opendaylight.mdsal.binding.model.api.AnnotationType;
import org.opendaylight.mdsal.binding.model.api.GeneratedProperty;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.MethodSignature;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.ri.Types;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;

public class BuilderImplTemplate
extends AbstractBuilderTemplate {
    private final BuilderTemplate builder;

    public BuilderImplTemplate(BuilderTemplate builder, GeneratedType type) {
        super(builder.javaType().getEnclosedType((JavaTypeName)type.getIdentifier()), type, builder.targetType, builder.properties, builder.augmentType, builder.keyType);
        this.builder = builder;
    }

    @Override
    public CharSequence body() {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateDeprecatedAnnotation = this.generateDeprecatedAnnotation(this.targetType.getAnnotations());
        _builder.append((Object)_generateDeprecatedAnnotation);
        _builder.newLineIfNotEmpty();
        _builder.append("private static final class ");
        String _name = this.type().getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        String impIface = this.importedName((Type)this.targetType);
        _builder.newLineIfNotEmpty();
        if (this.augmentType != null) {
            _builder.append("    ");
            _builder.append("extends ");
            String _importedName = this.importedName(AbstractAugmentable.class);
            _builder.append(_importedName, "    ");
            _builder.append("<");
            _builder.append(impIface, "    ");
            _builder.append(">");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("    ");
        _builder.append("implements ");
        _builder.append(impIface, "    ");
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _generateFields = this.generateFields(true);
        _builder.append((Object)_generateFields, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _generateCopyConstructor = this.generateCopyConstructor((Type)this.builder.type(), (Type)this.type());
        _builder.append((Object)_generateCopyConstructor, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _generateGetters = this.generateGetters();
        _builder.append((Object)_generateGetters, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _generateNonnullGetters = this.generateNonnullGetters();
        _builder.append((Object)_generateNonnullGetters, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _generateHashCode = this.generateHashCode();
        _builder.append((Object)_generateHashCode, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _generateEquals = this.generateEquals();
        _builder.append((Object)_generateEquals, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _generateToString = this.generateToString();
        _builder.append((Object)_generateToString, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    @Override
    public CharSequence generateDeprecatedAnnotation(AnnotationType ann) {
        return this.generateAnnotation(ann);
    }

    private CharSequence generateGetters() {
        boolean _isEmpty;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        if (this.keyType != null) {
            _builder.append("@");
            String _importedName = this.importedName(JavaFileTemplate.OVERRIDE);
            _builder.append(_importedName);
            _builder.newLineIfNotEmpty();
            _builder.append("public ");
            String _importedName_1 = this.importedName(this.keyType);
            _builder.append(_importedName_1);
            _builder.append(" ");
            _builder.append("key");
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("return key;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
        }
        boolean bl = _not = !(_isEmpty = this.properties.isEmpty());
        if (_not) {
            boolean _hasElements = false;
            for (BuilderGeneratedProperty field : this.properties) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)"\n", "");
                }
                CharSequence _terMethod = this.getterMethod(field);
                _builder.append((Object)_terMethod);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private CharSequence generateNonnullGetters() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = this.properties.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _hasElements = false;
            for (BuilderGeneratedProperty field : this.properties) {
                Type _returnType_1;
                boolean _isNonPresenceContainer;
                Type _returnType;
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)"\n", "");
                }
                if (!((_returnType = field.getReturnType()) instanceof GeneratedType) || !(_isNonPresenceContainer = GeneratorUtil.isNonPresenceContainer((GeneratedType)(_returnType_1 = field.getReturnType())))) continue;
                CharSequence _nonNullGetterMethod = this.nonNullGetterMethod(field);
                _builder.append((Object)_nonNullGetterMethod);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private static Optional<MethodSignature> findGetter(GeneratedType implType, String getterName) {
        Optional<MethodSignature> getter = JavaFileTemplate.getterByName(AbstractBuilderTemplate.nonDefaultMethods(implType), getterName);
        boolean _isPresent = getter.isPresent();
        if (_isPresent) {
            return getter;
        }
        List _implements = implType.getImplements();
        for (Type ifc : _implements) {
            Optional<MethodSignature> getterImpl;
            boolean _isPresent_1;
            if (!(ifc instanceof GeneratedType) || !(_isPresent_1 = (getterImpl = BuilderImplTemplate.findGetter((GeneratedType)ifc, getterName)).isPresent())) continue;
            return getterImpl;
        }
        return Optional.empty();
    }

    @Override
    public CharSequence getterMethod(GeneratedProperty field) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("@");
        String _importedName = this.importedName(JavaFileTemplate.OVERRIDE);
        _builder.append(_importedName);
        _builder.newLineIfNotEmpty();
        _builder.append("public ");
        String _importedName_1 = this.importedName(field.getReturnType());
        _builder.append(_importedName_1);
        _builder.append(" ");
        String _terMethodName = this.getterMethodName(field);
        _builder.append(_terMethodName);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        String fieldName = this.fieldName(field);
        _builder.newLineIfNotEmpty();
        boolean _endsWith = field.getReturnType().getName().endsWith("[]");
        if (_endsWith) {
            _builder.append("    ");
            _builder.append("return ");
            _builder.append(fieldName, "    ");
            _builder.append(" == null ? null : ");
            _builder.append(fieldName, "    ");
            _builder.append(".clone();");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("    ");
            _builder.append("return ");
            _builder.append(fieldName, "    ");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence nonNullGetterMethod(GeneratedProperty field) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("@");
        String _importedName = this.importedName(JavaFileTemplate.OVERRIDE);
        _builder.append(_importedName);
        _builder.newLineIfNotEmpty();
        Type type = field.getReturnType();
        _builder.newLineIfNotEmpty();
        _builder.append("public ");
        String _importedName_1 = this.importedName(type);
        _builder.append(_importedName_1);
        _builder.append(" ");
        String _nonnullMethodName = this.nonnullMethodName(field);
        _builder.append(_nonnullMethodName);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("return ");
        String _importedName_2 = this.importedName(JavaFileTemplate.JU_OBJECTS);
        _builder.append(_importedName_2, "    ");
        _builder.append(".requireNonNullElse(");
        String _terMethodName = this.getterMethodName(field);
        _builder.append(_terMethodName, "    ");
        _builder.append("(), ");
        String _fullyQualifiedName = type.getFullyQualifiedName();
        _builder.append(_fullyQualifiedName, "    ");
        _builder.append("Builder", "    ");
        _builder.append(".empty());");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private String nonnullMethodName(GeneratedProperty field) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("nonnull");
        String _firstUpper = StringExtensions.toFirstUpper((String)field.getName());
        _builder.append(_firstUpper);
        return _builder.toString();
    }

    MethodSignature findGetter(String getterName) {
        Optional<MethodSignature> ownGetter = JavaFileTemplate.getterByName(AbstractBuilderTemplate.nonDefaultMethods(this.type()), getterName);
        boolean _isPresent = ownGetter.isPresent();
        if (_isPresent) {
            return ownGetter.get();
        }
        List _implements = this.type().getImplements();
        for (Type ifc : _implements) {
            Optional<MethodSignature> getter;
            boolean _isPresent_1;
            if (!(ifc instanceof GeneratedType) || !(_isPresent_1 = (getter = BuilderImplTemplate.findGetter((GeneratedType)ifc, getterName)).isPresent())) continue;
            return getter.get();
        }
        String _format = String.format("%s should be present in %s type or in one of its ancestors as getter", JavaFileTemplate.propertyNameFromGetter(getterName), this.type());
        throw new IllegalStateException(_format);
    }

    protected CharSequence generateHashCode() {
        StringConcatenation _builder = new StringConcatenation();
        if (!this.properties.isEmpty() || this.augmentType != null) {
            _builder.append("private int hash = 0;");
            _builder.newLine();
            _builder.append("private volatile boolean hashValid = false;");
            _builder.newLine();
            _builder.newLine();
            _builder.append("@");
            String _importedName = this.importedName(JavaFileTemplate.OVERRIDE);
            _builder.append(_importedName);
            _builder.newLineIfNotEmpty();
            _builder.append("public int hashCode() {");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("if (hashValid) {");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("return hash;");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
            _builder.append("    ");
            _builder.append("final int result = ");
            String _importedName_1 = this.importedName((Type)this.targetType);
            _builder.append(_importedName_1, "    ");
            _builder.append(".");
            _builder.append("bindingHashCode", "    ");
            _builder.append("(this);");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("hash = result;");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("hashValid = true;");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("return result;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence generateEquals() {
        StringConcatenation _builder = new StringConcatenation();
        if (!this.properties.isEmpty() || this.augmentType != null) {
            _builder.append("@");
            String _importedName = this.importedName(JavaFileTemplate.OVERRIDE);
            _builder.append(_importedName);
            _builder.newLineIfNotEmpty();
            _builder.append("public boolean equals(");
            String _importedName_1 = this.importedName((Type)Types.objectType());
            _builder.append(_importedName_1);
            _builder.append(" obj) {");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("return ");
            String _importedName_2 = this.importedName((Type)this.targetType);
            _builder.append(_importedName_2, "    ");
            _builder.append(".");
            _builder.append("bindingEquals", "    ");
            _builder.append("(this, obj);");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence generateToString() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("@");
        String _importedName = this.importedName(JavaFileTemplate.OVERRIDE);
        _builder.append(_importedName);
        _builder.newLineIfNotEmpty();
        _builder.append("public ");
        String _importedName_1 = this.importedName((Type)Types.STRING);
        _builder.append(_importedName_1);
        _builder.append(" toString() {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("return ");
        String _importedName_2 = this.importedName((Type)this.targetType);
        _builder.append(_importedName_2, "    ");
        _builder.append(".");
        _builder.append("bindingToString", "    ");
        _builder.append("(this);");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    @Override
    protected CharSequence generateCopyKeys(List<GeneratedProperty> keyProps) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if (base.");
        _builder.append("key");
        _builder.append("() != null) {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("this.key = base.");
        _builder.append("key", "    ");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("} else {");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("this.key = new ");
        String _importedName = this.importedName(this.keyType);
        _builder.append(_importedName, "    ");
        _builder.append("(");
        boolean _hasElements = false;
        for (GeneratedProperty keyProp : keyProps) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "    ");
            }
            _builder.append("base.");
            String _terMethodName = this.getterMethodName(keyProp);
            _builder.append(_terMethodName, "    ");
            _builder.append("()");
        }
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        for (GeneratedProperty field : keyProps) {
            _builder.append("this.");
            String _fieldName = this.fieldName(field);
            _builder.append(_fieldName);
            _builder.append(" = key.");
            String _terMethodName_1 = this.getterMethodName(field);
            _builder.append(_terMethodName_1);
            _builder.append("();");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    @Override
    protected CharSequence generateCopyNonKeys(Collection<BuilderGeneratedProperty> props) {
        StringConcatenation _builder = new StringConcatenation();
        for (BuilderGeneratedProperty field : props) {
            boolean _tripleEquals;
            MethodSignature.ValueMechanics _mechanics = field.getMechanics();
            boolean bl = _tripleEquals = _mechanics == MethodSignature.ValueMechanics.NULLIFY_EMPTY;
            if (_tripleEquals) {
                _builder.append("this.");
                String _fieldName = this.fieldName(field);
                _builder.append(_fieldName);
                _builder.append(" = ");
                String _importedName = this.importedName(JavaFileTemplate.CODEHELPERS);
                _builder.append(_importedName);
                _builder.append(".emptyToNull(base.");
                String _getterName = field.getGetterName();
                _builder.append(_getterName);
                _builder.append("());");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append("this.");
            String _fieldName_1 = this.fieldName(field);
            _builder.append(_fieldName_1);
            _builder.append(" = base.");
            String _getterName_1 = field.getGetterName();
            _builder.append(_getterName_1);
            _builder.append("();");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    @Override
    protected CharSequence generateCopyAugmentation(Type implType) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("super(base.");
        _builder.append("augmentation");
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        return _builder;
    }
}

