/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.java.api.generator;

import java.util.List;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.opendaylight.mdsal.binding.generator.BindingGeneratorUtil;
import org.opendaylight.mdsal.binding.java.api.generator.AbstractJavaGeneratedType;
import org.opendaylight.mdsal.binding.java.api.generator.BaseTemplate;
import org.opendaylight.mdsal.binding.java.api.generator.JavaFileTemplate;
import org.opendaylight.mdsal.binding.model.api.Enumeration;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.ri.Types;
import org.opendaylight.yangtools.yang.binding.EnumTypeObject;

public class EnumTemplate
extends BaseTemplate {
    private static final JavaTypeName ENUM_TYPE_OBJECT = JavaTypeName.create(EnumTypeObject.class);
    private final Enumeration enums;

    public EnumTemplate(AbstractJavaGeneratedType javaType, Enumeration enums) {
        super(javaType, (GeneratedType)enums);
        this.enums = enums;
    }

    public EnumTemplate(Enumeration enums) {
        super((GeneratedType)enums);
        this.enums = enums;
    }

    public CharSequence generateAsInnerClass() {
        return this.body();
    }

    public CharSequence writeEnumItem(String name, String mappedName, int value, String description) {
        StringConcatenation _builder = new StringConcatenation();
        if (description != null) {
            String _wrapToDocumentation = BaseTemplate.wrapToDocumentation(JavaFileTemplate.encodeJavadocSymbols(BindingGeneratorUtil.encodeAngleBrackets((String)description.trim())));
            _builder.append(_wrapToDocumentation);
            _builder.newLineIfNotEmpty();
        }
        _builder.append(mappedName);
        _builder.append("(");
        _builder.append((Object)value);
        _builder.append(", \"");
        _builder.append(name);
        _builder.append("\")");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @Override
    public CharSequence body() {
        StringConcatenation _builder = new StringConcatenation();
        String _wrapToDocumentation = BaseTemplate.wrapToDocumentation(this.formatDataForJavaDoc((GeneratedType)this.enums));
        _builder.append(_wrapToDocumentation);
        _builder.newLineIfNotEmpty();
        String _generatedAnnotation = this.generatedAnnotation();
        _builder.append(_generatedAnnotation);
        _builder.newLineIfNotEmpty();
        _builder.append("public enum ");
        String _name = this.enums.getName();
        _builder.append(_name);
        _builder.append(" implements ");
        String _importedName = this.importedName(ENUM_TYPE_OBJECT);
        _builder.append(_importedName);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        CharSequence _writeEnumeration = this.writeEnumeration(this.enums);
        _builder.append((Object)_writeEnumeration, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("private final ");
        String _importedNonNull = this.importedNonNull((Type)Types.STRING);
        _builder.append(_importedNonNull, "    ");
        _builder.append(" name;");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("private final int value;");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("private ");
        String _name_1 = this.enums.getName();
        _builder.append(_name_1, "    ");
        _builder.append("(int value, ");
        String _importedNonNull_1 = this.importedNonNull((Type)Types.STRING);
        _builder.append(_importedNonNull_1, "    ");
        _builder.append(" name) {");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("this.value = value;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("this.name = name;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("@");
        String _importedName_1 = this.importedName(JavaFileTemplate.OVERRIDE);
        _builder.append(_importedName_1, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("public ");
        String _importedNonNull_2 = this.importedNonNull((Type)Types.STRING);
        _builder.append(_importedNonNull_2, "    ");
        _builder.append(" getName() {");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("return name;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("@");
        String _importedName_2 = this.importedName(JavaFileTemplate.OVERRIDE);
        _builder.append(_importedName_2, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("public int getIntValue() {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("return value;");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* Return the enumeration member whose {@link #getName()} matches specified assigned name.");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* @param name YANG assigned name");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* @return corresponding ");
        String _name_2 = this.enums.getName();
        _builder.append(_name_2, "     ");
        _builder.append(" item, or {@code null} if no such item exists");
        _builder.newLineIfNotEmpty();
        _builder.append("     ");
        _builder.append("* @throws ");
        String _importedName_3 = this.importedName(JavaFileTemplate.NPE);
        _builder.append(_importedName_3, "     ");
        _builder.append(" if {@code name} is null");
        _builder.newLineIfNotEmpty();
        _builder.append("     ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public static ");
        String _importedNullable = this.importedNullable((Type)this.enums);
        _builder.append(_importedNullable, "    ");
        _builder.append(" forName(");
        String _importedName_4 = this.importedName((Type)Types.STRING);
        _builder.append(_importedName_4, "    ");
        _builder.append(" name) {");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("return switch (name) {");
        _builder.newLine();
        List _values = this.enums.getValues();
        for (Enumeration.Pair v : _values) {
            _builder.append("            ");
            _builder.append("case \"");
            String _name_3 = v.getName();
            _builder.append(_name_3, "            ");
            _builder.append("\" -> ");
            String _mappedName = v.getMappedName();
            _builder.append(_mappedName, "            ");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("            ");
        _builder.append("default -> null;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("};");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* Return the enumeration member whose {@link #getIntValue()} matches specified value.");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* @param intValue integer value");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* @return corresponding ");
        String _name_4 = this.enums.getName();
        _builder.append(_name_4, "     ");
        _builder.append(" item, or {@code null} if no such item exists");
        _builder.newLineIfNotEmpty();
        _builder.append("     ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public static ");
        String _importedNullable_1 = this.importedNullable((Type)this.enums);
        _builder.append(_importedNullable_1, "    ");
        _builder.append(" forValue(int intValue) {");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("return switch (intValue) {");
        _builder.newLine();
        List _values_1 = this.enums.getValues();
        for (Enumeration.Pair v_1 : _values_1) {
            _builder.append("            ");
            _builder.append("case ");
            int _value = v_1.getValue();
            _builder.append((Object)_value, "            ");
            _builder.append(" -> ");
            String _mappedName_1 = v_1.getMappedName();
            _builder.append(_mappedName_1, "            ");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("            ");
        _builder.append("default -> null;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("};");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* Return the enumeration member whose {@link #getName()} matches specified assigned name.");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* @param name YANG assigned name");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* @return corresponding ");
        String _name_5 = this.enums.getName();
        _builder.append(_name_5, "     ");
        _builder.append(" item");
        _builder.newLineIfNotEmpty();
        _builder.append("     ");
        _builder.append("* @throws ");
        String _importedName_5 = this.importedName(JavaFileTemplate.NPE);
        _builder.append(_importedName_5, "     ");
        _builder.append(" if {@code name} is null");
        _builder.newLineIfNotEmpty();
        _builder.append("     ");
        _builder.append("* @throws ");
        String _importedName_6 = this.importedName(JavaFileTemplate.IAE);
        _builder.append(_importedName_6, "     ");
        _builder.append(" if {@code name} does not match any item");
        _builder.newLineIfNotEmpty();
        _builder.append("     ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public static ");
        String _importedNonNull_3 = this.importedNonNull((Type)this.enums);
        _builder.append(_importedNonNull_3, "    ");
        _builder.append(" ofName(");
        String _importedName_7 = this.importedName((Type)Types.STRING);
        _builder.append(_importedName_7, "    ");
        _builder.append(" name) {");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("return ");
        String _importedName_8 = this.importedName(JavaFileTemplate.CODEHELPERS);
        _builder.append(_importedName_8, "        ");
        _builder.append(".checkEnum(forName(name), name);");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("/**");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* Return the enumeration member whose {@link #getIntValue()} matches specified value.");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("*");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* @param intValue integer value");
        _builder.newLine();
        _builder.append("     ");
        _builder.append("* @return corresponding ");
        String _name_6 = this.enums.getName();
        _builder.append(_name_6, "     ");
        _builder.append(" item");
        _builder.newLineIfNotEmpty();
        _builder.append("     ");
        _builder.append("* @throws ");
        String _importedName_9 = this.importedName(JavaFileTemplate.IAE);
        _builder.append(_importedName_9, "     ");
        _builder.append(" if {@code intValue} does not match any item");
        _builder.newLineIfNotEmpty();
        _builder.append("     ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("public static ");
        String _importedNonNull_4 = this.importedNonNull((Type)this.enums);
        _builder.append(_importedNonNull_4, "    ");
        _builder.append(" ofValue(int intValue) {");
        _builder.newLineIfNotEmpty();
        _builder.append("        ");
        _builder.append("return ");
        String _importedName_10 = this.importedName(JavaFileTemplate.CODEHELPERS);
        _builder.append(_importedName_10, "        ");
        _builder.append(".checkEnum(forValue(intValue), intValue);");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence writeEnumeration(Enumeration enumeration) {
        StringConcatenation _builder = new StringConcatenation();
        List _values = enumeration.getValues();
        boolean _hasElements = false;
        for (Enumeration.Pair v : _values) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",\n", "");
            }
            CharSequence _writeEnumItem = this.writeEnumItem(v.getName(), v.getMappedName(), v.getValue(), v.getDescription().orElse(null));
            _builder.append((Object)_writeEnumItem);
        }
        if (_hasElements) {
            _builder.append(";");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }
}

