/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.java.api.generator;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;
import org.opendaylight.mdsal.binding.java.api.generator.AbstractJavaGeneratedType;
import org.opendaylight.mdsal.binding.java.api.generator.BaseTemplate;
import org.opendaylight.mdsal.binding.java.api.generator.BuilderGeneratedProperty;
import org.opendaylight.mdsal.binding.java.api.generator.ByTypeMemberComparator;
import org.opendaylight.mdsal.binding.java.api.generator.EnumTemplate;
import org.opendaylight.mdsal.binding.java.api.generator.JavaFileTemplate;
import org.opendaylight.mdsal.binding.java.api.generator.NestedJavaGeneratedType;
import org.opendaylight.mdsal.binding.model.api.AnnotationType;
import org.opendaylight.mdsal.binding.model.api.Constant;
import org.opendaylight.mdsal.binding.model.api.Enumeration;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.MethodSignature;
import org.opendaylight.mdsal.binding.model.api.ParameterizedType;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.TypeMemberComment;
import org.opendaylight.mdsal.binding.model.ri.Types;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;

public class InterfaceTemplate
extends BaseTemplate {
    private final List<Constant> consts;
    private final List<MethodSignature> methods;
    private final List<Enumeration> enums;
    private final List<GeneratedType> enclosedGeneratedTypes;
    private Map.Entry<Type, Set<BuilderGeneratedProperty>> typeAnalysis;

    public InterfaceTemplate(GeneratedType genType) {
        super(genType);
        this.consts = genType.getConstantDefinitions();
        this.methods = genType.getMethodDefinitions();
        this.enums = genType.getEnumerations();
        this.enclosedGeneratedTypes = genType.getEnclosedTypes();
    }

    @Override
    public CharSequence body() {
        StringConcatenation _builder = new StringConcatenation();
        String _wrapToDocumentation = BaseTemplate.wrapToDocumentation(this.formatDataForJavaDoc(this.type()));
        _builder.append(_wrapToDocumentation);
        _builder.newLineIfNotEmpty();
        CharSequence _generateAnnotations = this.generateAnnotations(this.type().getAnnotations());
        _builder.append((Object)_generateAnnotations);
        _builder.newLineIfNotEmpty();
        String _generatedAnnotation = this.generatedAnnotation();
        _builder.append(_generatedAnnotation);
        _builder.newLineIfNotEmpty();
        _builder.append("public interface ");
        String _name = this.type().getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        CharSequence _superInterfaces = this.superInterfaces();
        _builder.append((Object)_superInterfaces, "    ");
        _builder.newLineIfNotEmpty();
        _builder.append("{");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _generateInnerClasses = this.generateInnerClasses();
        _builder.append((Object)_generateInnerClasses, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _generateEnums = this.generateEnums();
        _builder.append((Object)_generateEnums, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _generateConstants = this.generateConstants();
        _builder.append((Object)_generateConstants, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        CharSequence _generateMethods = this.generateMethods();
        _builder.append((Object)_generateMethods, "    ");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateAnnotations(List<AnnotationType> annotations) {
        StringConcatenation _builder = new StringConcatenation();
        if (annotations != null && !annotations.isEmpty()) {
            for (AnnotationType annotation : annotations) {
                CharSequence _generateAnnotation = this.generateAnnotation(annotation);
                _builder.append((Object)_generateAnnotation);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private CharSequence generateAccessorAnnotations(MethodSignature method) {
        StringConcatenation _builder = new StringConcatenation();
        List annotations = method.getAnnotations();
        _builder.newLineIfNotEmpty();
        if (annotations != null && !annotations.isEmpty()) {
            for (AnnotationType annotation : annotations) {
                if (Types.BOOLEAN.equals(method.getReturnType()) && JavaFileTemplate.OVERRIDE.equals(annotation.getIdentifier())) continue;
                CharSequence _generateAnnotation = this.generateAnnotation(annotation);
                _builder.append((Object)_generateAnnotation);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private CharSequence superInterfaces() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = this.type().getImplements().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("extends");
            _builder.newLine();
            List _implements = this.type().getImplements();
            boolean _hasElements = false;
            for (Type type : _implements) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",", "");
                }
                String _importedName = this.importedName(type);
                _builder.append(_importedName);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private CharSequence generateInnerClasses() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = this.enclosedGeneratedTypes.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _hasElements = false;
            for (GeneratedType innerClass : this.enclosedGeneratedTypes) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)"\n", "");
                }
                CharSequence _generateInnerClass = this.generateInnerClass(innerClass);
                _builder.append((Object)_generateInnerClass);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private CharSequence generateEnums() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = this.enums.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _hasElements = false;
            for (Enumeration e : this.enums) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)"\n", "");
                }
                NestedJavaGeneratedType _enclosedType = this.javaType().getEnclosedType((JavaTypeName)e.getIdentifier());
                EnumTemplate enumTemplate = new EnumTemplate((AbstractJavaGeneratedType)_enclosedType, e);
                _builder.newLineIfNotEmpty();
                CharSequence _generateAsInnerClass = enumTemplate.generateAsInnerClass();
                _builder.append((Object)_generateAsInnerClass);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private CharSequence generateConstants() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = this.consts.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            for (Constant c : this.consts) {
                boolean _startsWith = c.getName().startsWith("PATTERN_CONSTANTS");
                boolean _not_1 = !_startsWith;
                if (!_not_1) continue;
                CharSequence _emitConstant = this.emitConstant(c);
                _builder.append((Object)_emitConstant);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private CharSequence generateMethods() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = this.methods.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            boolean _hasElements = false;
            for (MethodSignature m : this.methods) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)"\n", "");
                }
                boolean _isDefault = m.isDefault();
                if (_isDefault) {
                    CharSequence _generateDefaultMethod = this.generateDefaultMethod(m);
                    _builder.append((Object)_generateDefaultMethod);
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                boolean _isStatic = m.isStatic();
                if (_isStatic) {
                    CharSequence _generateStaticMethod = this.generateStaticMethod(m);
                    _builder.append((Object)_generateStaticMethod);
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                if (m.getParameters().isEmpty() && BindingMapping.isGetterMethodName((String)m.getName())) {
                    String _generateAccessorMethod = this.generateAccessorMethod(m);
                    _builder.append(_generateAccessorMethod);
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                if (m.getParameters().isEmpty() && BindingMapping.isNonnullMethodName((String)m.getName())) {
                    String _generateNonnullAccessorMethod = this.generateNonnullAccessorMethod(m);
                    _builder.append(_generateNonnullAccessorMethod);
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                CharSequence _generateMethod = this.generateMethod(m);
                _builder.append((Object)_generateMethod);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    @SuppressModernizer
    private CharSequence generateDefaultMethod(MethodSignature method) {
        CharSequence _xifexpression = null;
        boolean _isNonnullMethodName = BindingMapping.isNonnullMethodName((String)method.getName());
        if (_isNonnullMethodName) {
            _xifexpression = this.generateNonnullMethod(method);
        } else {
            CharSequence _xifexpression_1 = null;
            boolean _isRequireMethodName = BindingMapping.isRequireMethodName((String)method.getName());
            if (_isRequireMethodName) {
                _xifexpression_1 = this.generateRequireMethod(method);
            } else {
                CharSequence _switchResult = null;
                String _name = method.getName();
                if (_name != null) {
                    switch (_name) {
                        case "implementedInterface": {
                            _switchResult = this.generateDefaultImplementedInterface();
                            break;
                        }
                        default: {
                            CharSequence _xifexpression_2 = null;
                            boolean _equals = JavaFileTemplate.VOID.equals(method.getReturnType().getIdentifier());
                            if (_equals) {
                                _xifexpression_2 = this.generateNoopVoidInterfaceMethod(method);
                            }
                            _switchResult = _xifexpression_2;
                            break;
                        }
                    }
                } else {
                    CharSequence _xifexpression_2 = null;
                    boolean _equals = JavaFileTemplate.VOID.equals(method.getReturnType().getIdentifier());
                    if (_equals) {
                        _xifexpression_2 = this.generateNoopVoidInterfaceMethod(method);
                    }
                    _switchResult = _xifexpression_2;
                }
                _xifexpression_1 = _switchResult;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    @SuppressModernizer
    private CharSequence generateStaticMethod(MethodSignature method) {
        CharSequence _switchResult = null;
        String _name = method.getName();
        if (_name != null) {
            switch (_name) {
                case "bindingEquals": {
                    _switchResult = this.generateBindingEquals();
                    break;
                }
                case "bindingHashCode": {
                    _switchResult = this.generateBindingHashCode();
                    break;
                }
                case "bindingToString": {
                    _switchResult = this.generateBindingToString();
                    break;
                }
                default: {
                    _switchResult = "";
                    break;
                }
            }
        } else {
            _switchResult = "";
        }
        return _switchResult;
    }

    private CharSequence generateMethod(MethodSignature method) {
        StringConcatenation _builder = new StringConcatenation();
        String _asJavadoc = this.asJavadoc(method.getComment());
        _builder.append(_asJavadoc);
        _builder.newLineIfNotEmpty();
        CharSequence _generateAnnotations = this.generateAnnotations(method.getAnnotations());
        _builder.append((Object)_generateAnnotations);
        _builder.newLineIfNotEmpty();
        String _importedName = this.importedName(method.getReturnType());
        _builder.append(_importedName);
        _builder.append(" ");
        String _name = method.getName();
        _builder.append(_name);
        _builder.append("(");
        CharSequence _generateParameters = this.generateParameters(method.getParameters());
        _builder.append((Object)_generateParameters);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence generateNoopVoidInterfaceMethod(MethodSignature method) {
        StringConcatenation _builder = new StringConcatenation();
        String _asJavadoc = this.asJavadoc(method.getComment());
        _builder.append(_asJavadoc);
        _builder.newLineIfNotEmpty();
        CharSequence _generateAnnotations = this.generateAnnotations(method.getAnnotations());
        _builder.append((Object)_generateAnnotations);
        _builder.newLineIfNotEmpty();
        _builder.append("default ");
        String _importedName = this.importedName(JavaFileTemplate.VOID);
        _builder.append(_importedName);
        _builder.append(" ");
        String _name = method.getName();
        _builder.append(_name);
        _builder.append("(");
        CharSequence _generateParameters = this.generateParameters(method.getParameters());
        _builder.append((Object)_generateParameters);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("// No-op");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private String accessorJavadoc(MethodSignature method, String orString) {
        return this.accessorJavadoc(method, orString, null);
    }

    private String accessorJavadoc(MethodSignature method, String orString, JavaTypeName exception) {
        String propName = JavaFileTemplate.propertyNameFromGetter(method);
        String propReturn = propName + orString;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Return ");
        _builder.append(propReturn);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        TypeMemberComment _comment = method.getComment();
        String _referenceDescription = null;
        if (_comment != null) {
            _referenceDescription = _comment.referenceDescription();
        }
        CharSequence _formatReference = BaseTemplate.formatReference(_referenceDescription);
        _builder.append((Object)_formatReference);
        _builder.newLineIfNotEmpty();
        _builder.append("@return {@code ");
        String _importedName = this.importedName(method.getReturnType());
        _builder.append(_importedName);
        _builder.append("} ");
        _builder.append(propReturn);
        _builder.newLineIfNotEmpty();
        if (exception != null) {
            _builder.append("@throws ");
            String _importedName_1 = this.importedName(exception);
            _builder.append(_importedName_1);
            _builder.append(" if ");
            _builder.append(propName);
            _builder.append(" is not present");
            _builder.newLineIfNotEmpty();
        }
        return BaseTemplate.wrapToDocumentation(_builder.toString());
    }

    private String generateAccessorMethod(MethodSignature method) {
        StringConcatenation _builder = new StringConcatenation();
        String _accessorJavadoc = this.accessorJavadoc(method, ", or {@code null} if it is not present.");
        _builder.append(_accessorJavadoc);
        _builder.newLineIfNotEmpty();
        CharSequence _generateAccessorAnnotations = this.generateAccessorAnnotations(method);
        _builder.append((Object)_generateAccessorAnnotations);
        _builder.newLineIfNotEmpty();
        String _nullableType = this.nullableType(method.getReturnType());
        _builder.append(_nullableType);
        _builder.append(" ");
        String _name = method.getName();
        _builder.append(_name);
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private String generateNonnullAccessorMethod(MethodSignature method) {
        StringConcatenation _builder = new StringConcatenation();
        String _accessorJavadoc = this.accessorJavadoc(method, ", or an empty instance if it is not present.");
        _builder.append(_accessorJavadoc);
        _builder.newLineIfNotEmpty();
        CharSequence _generateAnnotations = this.generateAnnotations(method.getAnnotations());
        _builder.append((Object)_generateAnnotations);
        _builder.newLineIfNotEmpty();
        String _importedNonNull = this.importedNonNull(method.getReturnType());
        _builder.append(_importedNonNull);
        _builder.append(" ");
        String _name = method.getName();
        _builder.append(_name);
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    private CharSequence generateDefaultImplementedInterface() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("@");
        String _importedName = this.importedName(JavaFileTemplate.OVERRIDE);
        _builder.append(_importedName);
        _builder.newLineIfNotEmpty();
        _builder.append("default ");
        String _importedName_1 = this.importedName(JavaFileTemplate.CLASS);
        _builder.append(_importedName_1);
        _builder.append("<");
        String _fullyQualifiedName = this.type().getFullyQualifiedName();
        _builder.append(_fullyQualifiedName);
        _builder.append("> ");
        _builder.append("implementedInterface");
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("return ");
        String _fullyQualifiedName_1 = this.type().getFullyQualifiedName();
        _builder.append(_fullyQualifiedName_1, "    ");
        _builder.append(".class;");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    @VisibleForTesting
    public CharSequence generateBindingHashCode() {
        StringConcatenation _builder = new StringConcatenation();
        boolean augmentable = this.analyzeType();
        _builder.newLineIfNotEmpty();
        if (augmentable || !this.typeAnalysis.getValue().isEmpty()) {
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* Default implementation of {@link ");
            String _importedName = this.importedName(Object.class);
            _builder.append(_importedName, " ");
            _builder.append("#hashCode()} contract for this interface.");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("* Implementations of this interface are encouraged to defer to this method to get consistent hashing");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* results across all implementations.");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @param obj Object for which to generate hashCode() result.");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @return Hash code value of data modeled by this interface.");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @throws ");
            String _importedName_1 = this.importedName(JavaFileTemplate.NPE);
            _builder.append(_importedName_1, " ");
            _builder.append(" if {@code obj} is null");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("static int ");
            _builder.append("bindingHashCode");
            _builder.append("(final ");
            String _fullyQualifiedNonNull = this.fullyQualifiedNonNull((Type)this.type());
            _builder.append(_fullyQualifiedNonNull);
            _builder.append(" obj) {");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("final int prime = 31;");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("int result = 1;");
            _builder.newLine();
            Set<BuilderGeneratedProperty> _value = this.typeAnalysis.getValue();
            for (BuilderGeneratedProperty property : _value) {
                _builder.append("    ");
                _builder.append("result = prime * result + ");
                String _importedUtilClass = this.importedUtilClass(property);
                _builder.append(_importedUtilClass, "    ");
                _builder.append(".hashCode(obj.");
                String _terMethodName = this.getterMethodName(property);
                _builder.append(_terMethodName, "    ");
                _builder.append("());");
                _builder.newLineIfNotEmpty();
            }
            if (augmentable) {
                _builder.append("    ");
                _builder.append("for (var augmentation : obj.augmentations().values()) {");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("result += augmentation.hashCode();");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
            }
            _builder.append("    ");
            _builder.append("return result;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    private CharSequence generateBindingEquals() {
        StringConcatenation _builder = new StringConcatenation();
        boolean augmentable = this.analyzeType();
        _builder.newLineIfNotEmpty();
        if (augmentable || !this.typeAnalysis.getValue().isEmpty()) {
            _builder.append("/**");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* Default implementation of {@link ");
            String _importedName = this.importedName(Object.class);
            _builder.append(_importedName, " ");
            _builder.append("#equals(");
            String _importedName_1 = this.importedName(Object.class);
            _builder.append(_importedName_1, " ");
            _builder.append(")} contract for this interface.");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("* Implementations of this interface are encouraged to defer to this method to get consistent equality");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* results across all implementations.");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("*");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @param thisObj Object acting as the receiver of equals invocation");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @param obj Object acting as argument to equals invocation");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @return True if thisObj and obj are considered equal");
            _builder.newLine();
            _builder.append(" ");
            _builder.append("* @throws ");
            String _importedName_2 = this.importedName(JavaFileTemplate.NPE);
            _builder.append(_importedName_2, " ");
            _builder.append(" if {@code thisObj} is null");
            _builder.newLineIfNotEmpty();
            _builder.append(" ");
            _builder.append("*/");
            _builder.newLine();
            _builder.append("static boolean ");
            _builder.append("bindingEquals");
            _builder.append("(final ");
            String _fullyQualifiedNonNull = this.fullyQualifiedNonNull((Type)this.type());
            _builder.append(_fullyQualifiedNonNull);
            _builder.append(" thisObj, final ");
            String _importedName_3 = this.importedName((Type)Types.objectType());
            _builder.append(_importedName_3);
            _builder.append(" obj) {");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("if (thisObj == obj) {");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("return true;");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("}");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("final ");
            String _fullyQualifiedName = this.type().getFullyQualifiedName();
            _builder.append(_fullyQualifiedName, "    ");
            _builder.append(" other = ");
            String _importedName_4 = this.importedName(JavaFileTemplate.CODEHELPERS);
            _builder.append(_importedName_4, "    ");
            _builder.append(".checkCast(");
            String _fullyQualifiedName_1 = this.type().getFullyQualifiedName();
            _builder.append(_fullyQualifiedName_1, "    ");
            _builder.append(".class, obj);");
            _builder.newLineIfNotEmpty();
            _builder.append("    ");
            _builder.append("if (other == null) {");
            _builder.newLine();
            _builder.append("        ");
            _builder.append("return false;");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("}");
            _builder.newLine();
            Collection<BuilderGeneratedProperty> _sort = ByTypeMemberComparator.sort((Collection)this.typeAnalysis.getValue());
            for (BuilderGeneratedProperty property : _sort) {
                _builder.append("    ");
                _builder.append("if (!");
                String _importedUtilClass = this.importedUtilClass(property);
                _builder.append(_importedUtilClass, "    ");
                _builder.append(".equals(thisObj.");
                String _getterName = property.getGetterName();
                _builder.append(_getterName, "    ");
                _builder.append("(), other.");
                String _getterName_1 = property.getGetterName();
                _builder.append(_getterName_1, "    ");
                _builder.append("())) {");
                _builder.newLineIfNotEmpty();
                _builder.append("    ");
                _builder.append("    ");
                _builder.append("return false;");
                _builder.newLine();
                _builder.append("    ");
                _builder.append("}");
                _builder.newLine();
            }
            _builder.append("    ");
            _builder.append("return ");
            if (augmentable) {
                _builder.append("thisObj.augmentations().equals(other.augmentations())");
            } else {
                _builder.append("true");
            }
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence generateBindingToString() {
        StringConcatenation _builder = new StringConcatenation();
        boolean augmentable = this.analyzeType();
        _builder.newLineIfNotEmpty();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Default implementation of {@link ");
        String _importedName = this.importedName(Object.class);
        _builder.append(_importedName, " ");
        _builder.append("#toString()} contract for this interface.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* Implementations of this interface are encouraged to defer to this method to get consistent string");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* representations across all implementations.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param obj Object for which to generate toString() result.");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @return {@link ");
        String _importedName_1 = this.importedName((Type)Types.STRING);
        _builder.append(_importedName_1, " ");
        _builder.append("} value of data modeled by this interface.");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* @throws ");
        String _importedName_2 = this.importedName(JavaFileTemplate.NPE);
        _builder.append(_importedName_2, " ");
        _builder.append(" if {@code obj} is null");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("static ");
        String _importedName_3 = this.importedName((Type)Types.STRING);
        _builder.append(_importedName_3);
        _builder.append(" ");
        _builder.append("bindingToString");
        _builder.append("(final ");
        String _fullyQualifiedNonNull = this.fullyQualifiedNonNull((Type)this.type());
        _builder.append(_fullyQualifiedNonNull);
        _builder.append(" obj) {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("final var helper = ");
        String _importedName_4 = this.importedName(JavaFileTemplate.MOREOBJECTS);
        _builder.append(_importedName_4, "    ");
        _builder.append(".toStringHelper(\"");
        String _name = this.type().getName();
        _builder.append(_name, "    ");
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        Set<BuilderGeneratedProperty> _value = this.typeAnalysis.getValue();
        for (BuilderGeneratedProperty property : _value) {
            _builder.append("    ");
            String _importedName_5 = this.importedName(JavaFileTemplate.CODEHELPERS);
            _builder.append(_importedName_5, "    ");
            _builder.append(".appendValue(helper, \"");
            String _name_1 = property.getName();
            _builder.append(_name_1, "    ");
            _builder.append("\", obj.");
            String _getterName = property.getGetterName();
            _builder.append(_getterName, "    ");
            _builder.append("());");
            _builder.newLineIfNotEmpty();
        }
        if (augmentable) {
            _builder.append("    ");
            String _importedName_6 = this.importedName(JavaFileTemplate.CODEHELPERS);
            _builder.append(_importedName_6, "    ");
            _builder.append(".appendAugmentations(helper, \"");
            _builder.append("augmentation", "    ");
            _builder.append("\", obj);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("    ");
        _builder.append("return helper.toString();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateNonnullMethod(MethodSignature method) {
        StringConcatenation _builder = new StringConcatenation();
        Type ret = method.getReturnType();
        _builder.newLineIfNotEmpty();
        String name = method.getName();
        _builder.newLineIfNotEmpty();
        String _accessorJavadoc = this.accessorJavadoc(method, ", or an empty list if it is not present.");
        _builder.append(_accessorJavadoc);
        _builder.newLineIfNotEmpty();
        CharSequence _generateAnnotations = this.generateAnnotations(method.getAnnotations());
        _builder.append((Object)_generateAnnotations);
        _builder.newLineIfNotEmpty();
        _builder.append("default ");
        String _importedNonNull = this.importedNonNull(ret);
        _builder.append(_importedNonNull);
        _builder.append(" ");
        _builder.append(name);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("return ");
        String _importedName = this.importedName(JavaFileTemplate.CODEHELPERS);
        _builder.append(_importedName, "    ");
        _builder.append(".nonnull(");
        String _getterMethodForNonnull = BindingMapping.getGetterMethodForNonnull((String)name);
        _builder.append(_getterMethodForNonnull, "    ");
        _builder.append("());");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private CharSequence generateRequireMethod(MethodSignature method) {
        StringConcatenation _builder = new StringConcatenation();
        Type ret = method.getReturnType();
        _builder.newLineIfNotEmpty();
        String name = method.getName();
        _builder.newLineIfNotEmpty();
        String fieldName = name.toLowerCase(Locale.ROOT).replace("require", "");
        _builder.newLineIfNotEmpty();
        String _accessorJavadoc = this.accessorJavadoc(method, ", guaranteed to be non-null.", JavaFileTemplate.NSEE);
        _builder.append(_accessorJavadoc);
        _builder.newLineIfNotEmpty();
        _builder.append("default ");
        String _importedNonNull = this.importedNonNull(ret);
        _builder.append(_importedNonNull);
        _builder.append(" ");
        _builder.append(name);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        _builder.append("return ");
        String _importedName = this.importedName(JavaFileTemplate.CODEHELPERS);
        _builder.append(_importedName, "    ");
        _builder.append(".require(");
        String _getterMethodForRequire = BindingMapping.getGetterMethodForRequire((String)name);
        _builder.append(_getterMethodForRequire, "    ");
        _builder.append("(), \"");
        _builder.append(fieldName, "    ");
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private String nullableType(Type type) {
        ParameterizedType param;
        if (InterfaceTemplate.isObject(type) && type instanceof ParameterizedType && (Types.isMapType((ParameterizedType)(param = (ParameterizedType)type)) || Types.isListType((ParameterizedType)param) || Types.isSetType((ParameterizedType)param))) {
            return this.importedNullable(type);
        }
        return this.importedName(type);
    }

    private static boolean isObject(Type type) {
        boolean _isEmpty = type.getPackageName().isEmpty();
        return !_isEmpty;
    }

    private boolean analyzeType() {
        Type _key;
        boolean _xblockexpression = false;
        if (this.typeAnalysis == null) {
            this.typeAnalysis = JavaFileTemplate.analyzeTypeHierarchy(this.type());
        }
        _xblockexpression = (_key = this.typeAnalysis.getKey()) != null;
        return _xblockexpression;
    }
}

