/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.java.api.generator;

import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSortedSet;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.opendaylight.mdsal.binding.generator.BindingGeneratorUtil;
import org.opendaylight.mdsal.binding.java.api.generator.AbstractJavaGeneratedType;
import org.opendaylight.mdsal.binding.java.api.generator.AlphabeticallyTypeMemberComparator;
import org.opendaylight.mdsal.binding.java.api.generator.BuilderGeneratedProperty;
import org.opendaylight.mdsal.binding.java.api.generator.ClassTemplate;
import org.opendaylight.mdsal.binding.java.api.generator.NestedJavaGeneratedType;
import org.opendaylight.mdsal.binding.java.api.generator.TopLevelJavaGeneratedType;
import org.opendaylight.mdsal.binding.java.api.generator.UnionTemplate;
import org.opendaylight.mdsal.binding.model.api.AnnotationType;
import org.opendaylight.mdsal.binding.model.api.ConcreteType;
import org.opendaylight.mdsal.binding.model.api.GeneratedProperty;
import org.opendaylight.mdsal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.MethodSignature;
import org.opendaylight.mdsal.binding.model.api.ParameterizedType;
import org.opendaylight.mdsal.binding.model.api.Restrictions;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.YangSourceDefinition;
import org.opendaylight.mdsal.binding.model.ri.BindingTypes;
import org.opendaylight.mdsal.binding.model.ri.Types;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.model.export.DeclaredStatementFormatter;

class JavaFileTemplate {
    static final @NonNull JavaTypeName CLASS;
    static final @NonNull JavaTypeName DEPRECATED;
    static final @NonNull JavaTypeName IAE;
    static final @NonNull JavaTypeName NPE;
    static final @NonNull JavaTypeName NSEE;
    static final @NonNull JavaTypeName OBJECT;
    static final @NonNull JavaTypeName OVERRIDE;
    static final @NonNull JavaTypeName SUPPRESS_WARNINGS;
    static final @NonNull JavaTypeName VOID;
    static final @NonNull JavaTypeName JU_ARRAYS;
    static final @NonNull JavaTypeName JU_HASHMAP;
    static final @NonNull JavaTypeName JU_LIST;
    static final @NonNull JavaTypeName JU_MAP;
    static final @NonNull JavaTypeName JU_OBJECTS;
    static final @NonNull JavaTypeName JUR_PATTERN;
    static final @NonNull JavaTypeName GENERATED;
    static final @NonNull JavaTypeName NONNULL;
    static final @NonNull JavaTypeName NONNULL_BY_DEFAULT;
    static final @NonNull JavaTypeName NULLABLE;
    static final @NonNull JavaTypeName CODEHELPERS;
    static final @NonNull JavaTypeName MOREOBJECTS;
    private static final Comparator<MethodSignature> METHOD_COMPARATOR;
    private static final CharMatcher AMP_MATCHER;
    private static final Pattern TAIL_COMMENT_PATTERN;
    private static final DeclaredStatementFormatter YANG_FORMATTER;
    private static final int GETTER_PREFIX_LENGTH;
    private static final Type AUGMENTATION_RET_TYPE;
    private final AbstractJavaGeneratedType javaType;
    private final GeneratedType type;

    JavaFileTemplate(@NonNull GeneratedType type) {
        this(new TopLevelJavaGeneratedType(type), type);
    }

    JavaFileTemplate(AbstractJavaGeneratedType javaType, GeneratedType type) {
        this.javaType = Objects.requireNonNull(javaType);
        this.type = Objects.requireNonNull(type);
    }

    final AbstractJavaGeneratedType javaType() {
        return this.javaType;
    }

    final GeneratedType type() {
        return this.type;
    }

    final String generateImportBlock() {
        Verify.verify((boolean)(this.javaType instanceof TopLevelJavaGeneratedType));
        return ((TopLevelJavaGeneratedType)this.javaType).imports().map(name -> "import " + name + ";\n").collect(Collectors.joining());
    }

    final @NonNull String importedJavadocName(@NonNull Type intype) {
        Type type;
        if (intype instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)intype;
            type = parameterized.getRawType();
        } else {
            type = intype;
        }
        return this.importedName(type);
    }

    final @NonNull String importedName(@NonNull Type intype) {
        return this.javaType.getReferenceString(intype);
    }

    final @NonNull String importedName(@NonNull Type intype, @NonNull String annotation) {
        return this.javaType.getReferenceString(intype, annotation);
    }

    final @NonNull String importedName(Class<?> cls) {
        return this.importedName((Type)Types.typeForClass(cls));
    }

    final @NonNull String importedName(@NonNull JavaTypeName intype) {
        return this.javaType.getReferenceString(intype);
    }

    final @NonNull String importedNonNull(@NonNull Type intype) {
        return this.importedName(intype, this.importedName(NONNULL));
    }

    final @NonNull String importedNullable(@NonNull Type intype) {
        return this.importedName(intype, this.importedName(NULLABLE));
    }

    final @NonNull String fullyQualifiedNonNull(@NonNull Type intype) {
        return this.fullyQualifiedName(intype, this.importedName(NONNULL));
    }

    final @NonNull String fullyQualifiedName(@NonNull Type intype, @NonNull String annotation) {
        return this.javaType.getFullyQualifiedReference(intype, annotation);
    }

    boolean isLocalInnerClass(JavaTypeName name) {
        Optional optEnc = name.immediatelyEnclosingClass();
        return optEnc.isPresent() && ((JavaTypeName)this.type.getIdentifier()).equals(optEnc.get());
    }

    final CharSequence generateInnerClass(GeneratedType innerClass) {
        if (!(innerClass instanceof GeneratedTransferObject)) {
            return "";
        }
        GeneratedTransferObject gto = (GeneratedTransferObject)innerClass;
        NestedJavaGeneratedType innerJavaType = this.javaType.getEnclosedType((JavaTypeName)innerClass.getIdentifier());
        return gto.isUnionType() ? new UnionTemplate(innerJavaType, gto).generateAsInnerClass() : new ClassTemplate((AbstractJavaGeneratedType)innerJavaType, gto).generateAsInnerClass();
    }

    final String importedUtilClass(GeneratedProperty property) {
        return this.importedUtilClass(property.getReturnType());
    }

    final String importedUtilClass(Type returnType) {
        return this.importedName(returnType.getName().indexOf(91) != -1 ? JU_ARRAYS : JU_OBJECTS);
    }

    final String generatedAnnotation() {
        return "@" + this.importedName(GENERATED) + "(\"mdsal-binding-generator\")";
    }

    static Map.Entry<Type, Set<BuilderGeneratedProperty>> analyzeTypeHierarchy(GeneratedType type) {
        LinkedHashSet<MethodSignature> methods = new LinkedHashSet<MethodSignature>();
        ParameterizedType augmentType = JavaFileTemplate.createMethods(type, methods);
        ImmutableSortedSet sortedMethods = ImmutableSortedSet.orderedBy(METHOD_COMPARATOR).addAll(methods).build();
        return new AbstractMap.SimpleImmutableEntry<ParameterizedType, Set<BuilderGeneratedProperty>>(augmentType, JavaFileTemplate.propertiesFromMethods((Collection<MethodSignature>)sortedMethods));
    }

    static final Restrictions restrictionsForSetter(Type actualType) {
        return actualType instanceof GeneratedType ? null : JavaFileTemplate.getRestrictions(actualType);
    }

    static final Restrictions getRestrictions(Type type) {
        if (type instanceof ConcreteType) {
            return ((ConcreteType)type).getRestrictions();
        }
        if (type instanceof GeneratedTransferObject) {
            return ((GeneratedTransferObject)type).getRestrictions();
        }
        return null;
    }

    static final String cloneCall(GeneratedProperty property) {
        return property.getReturnType().getName().endsWith("[]") ? ".clone()" : "";
    }

    private static ParameterizedType createMethods(GeneratedType type, Set<MethodSignature> methods) {
        methods.addAll(type.getMethodDefinitions());
        return JavaFileTemplate.collectImplementedMethods(type, methods, type.getImplements());
    }

    private static ParameterizedType collectImplementedMethods(GeneratedType type, Set<MethodSignature> methods, List<Type> implementedIfcs) {
        if (implementedIfcs == null || implementedIfcs.isEmpty()) {
            return null;
        }
        ParameterizedType augmentType = null;
        for (Type implementedIfc : implementedIfcs) {
            if (implementedIfc instanceof GeneratedType) {
                GeneratedType ifc = (GeneratedType)implementedIfc;
                if (!(implementedIfc instanceof GeneratedTransferObject)) {
                    JavaFileTemplate.addImplMethods(methods, ifc);
                    ParameterizedType t = JavaFileTemplate.collectImplementedMethods(type, methods, ifc.getImplements());
                    if (t == null || augmentType != null) continue;
                    augmentType = t;
                    continue;
                }
            }
            if (!Augmentable.class.getName().equals(implementedIfc.getFullyQualifiedName())) continue;
            augmentType = Types.parameterizedTypeFor((Type)AUGMENTATION_RET_TYPE, (Type[])new Type[]{Type.of((JavaTypeName)((JavaTypeName)type.getIdentifier()))});
        }
        return augmentType;
    }

    private static void addImplMethods(Set<MethodSignature> methods, GeneratedType implType) {
        for (MethodSignature implMethod : implType.getMethodDefinitions()) {
            if (JavaFileTemplate.hasOverrideAnnotation(implMethod)) {
                methods.add(implMethod);
                continue;
            }
            String implMethodName = implMethod.getName();
            if (!BindingMapping.isGetterMethodName((String)implMethodName) || !JavaFileTemplate.getterByName(methods, implMethodName).isEmpty()) continue;
            methods.add(implMethod);
        }
    }

    protected static Optional<MethodSignature> getterByName(Iterable<MethodSignature> methods, String implMethodName) {
        for (MethodSignature method : methods) {
            String methodName = method.getName();
            if (!BindingMapping.isGetterMethodName((String)methodName) || !JavaFileTemplate.isSameProperty(method.getName(), implMethodName)) continue;
            return Optional.of(method);
        }
        return Optional.empty();
    }

    protected static String propertyNameFromGetter(MethodSignature getter) {
        return JavaFileTemplate.propertyNameFromGetter(getter.getName());
    }

    protected static String propertyNameFromGetter(String getterName) {
        String prefix;
        if (BindingMapping.isGetterMethodName((String)getterName)) {
            prefix = "get";
        } else if (BindingMapping.isNonnullMethodName((String)getterName)) {
            prefix = "nonnull";
        } else if (BindingMapping.isRequireMethodName((String)getterName)) {
            prefix = "require";
        } else {
            throw new IllegalArgumentException(getterName + " is not a getter");
        }
        return StringExtensions.toFirstLower((String)getterName.substring(prefix.length()));
    }

    static boolean hasOverrideAnnotation(MethodSignature method) {
        for (AnnotationType annotation : method.getAnnotations()) {
            if (!OVERRIDE.equals(annotation.getIdentifier())) continue;
            return true;
        }
        return false;
    }

    final void appendSnippet(StringBuilder sb, GeneratedType genType) {
        genType.getYangSourceDefinition().ifPresent(def -> {
            sb.append('\n');
            if (def instanceof YangSourceDefinition.Single) {
                GeneratedTransferObject genTO;
                Type augType;
                YangSourceDefinition.Single single = (YangSourceDefinition.Single)def;
                DocumentedNode node = single.getNode();
                sb.append("<p>\n").append("This class represents the following YANG schema fragment defined in module <b>").append(((UnresolvedQName.Unqualified)def.getModule().argument()).getLocalName()).append("</b>\n").append("<pre>\n");
                JavaFileTemplate.appendYangSnippet(sb, def.getModule(), ((EffectiveStatement)node).getDeclared());
                sb.append("</pre>");
                if (node instanceof SchemaNode) {
                    SchemaNode schema = (SchemaNode)node;
                    if (JavaFileTemplate.hasBuilderClass(schema)) {
                        String builderName = genType.getName() + "Builder";
                        sb.append("\n<p>To create instances of this class use {@link ").append(builderName).append("}.\n").append("@see ").append(builderName).append('\n');
                        if (node instanceof ListSchemaNode) {
                            List keyDef = ((ListSchemaNode)node).getKeyDefinition();
                            if (!keyDef.isEmpty()) {
                                sb.append("@see ").append(genType.getName()).append("Key");
                            }
                            sb.append('\n');
                        }
                    }
                } else if (node instanceof AugmentEffectiveStatement && (augType = JavaFileTemplate.findAugmentationArgument(genType)) != null) {
                    sb.append("\n\n").append("@see ").append(this.importedName(augType));
                }
                if (node instanceof TypedefEffectiveStatement && genType instanceof GeneratedTransferObject && (augType = (genTO = (GeneratedTransferObject)genType).getSuperType()) != null) {
                    sb.append("\n\n").append("@see ").append(augType.getName());
                }
            } else if (def instanceof YangSourceDefinition.Multiple) {
                YangSourceDefinition.Multiple multiple = (YangSourceDefinition.Multiple)def;
                sb.append("<pre>\n");
                for (SchemaNode node : multiple.getNodes()) {
                    JavaFileTemplate.appendYangSnippet(sb, def.getModule(), ((EffectiveStatement)node).getDeclared());
                }
                sb.append("</pre>\n");
            }
        });
    }

    private static @Nullable Type findAugmentationArgument(GeneratedType genType) {
        for (Type implType : genType.getImplements()) {
            ParameterizedType parameterized;
            Type augmentType;
            if (!(implType instanceof ParameterizedType) || (augmentType = BindingTypes.extractAugmentable((ParameterizedType)(parameterized = (ParameterizedType)implType))) == null) continue;
            return augmentType;
        }
        return null;
    }

    static String encodeJavadocSymbols(String description) {
        return description == null || description.isEmpty() ? description : TAIL_COMMENT_PATTERN.matcher(AMP_MATCHER.replaceFrom((CharSequence)description, (CharSequence)"&amp;")).replaceAll("&#42;&#47;");
    }

    private static void appendYangSnippet(StringBuilder sb, ModuleEffectiveStatement module, DeclaredStatement<?> stmt) {
        for (String str : YANG_FORMATTER.toYangTextSnippet(module, stmt)) {
            sb.append(BindingGeneratorUtil.replaceAllIllegalChars((String)BindingGeneratorUtil.encodeAngleBrackets((String)JavaFileTemplate.encodeJavadocSymbols(str))));
        }
    }

    private static boolean hasBuilderClass(SchemaNode schemaNode) {
        return schemaNode instanceof ContainerSchemaNode || schemaNode instanceof ListSchemaNode || schemaNode instanceof NotificationDefinition;
    }

    private static boolean isSameProperty(String getterName1, String getterName2) {
        return JavaFileTemplate.propertyNameFromGetter(getterName1).equals(JavaFileTemplate.propertyNameFromGetter(getterName2));
    }

    private static Set<BuilderGeneratedProperty> propertiesFromMethods(Collection<MethodSignature> methods) {
        if (methods == null || methods.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<BuilderGeneratedProperty> result = new LinkedHashSet<BuilderGeneratedProperty>();
        for (MethodSignature m : methods) {
            BuilderGeneratedProperty createdField = JavaFileTemplate.propertyFromGetter(m);
            if (createdField == null) continue;
            result.add(createdField);
        }
        return result;
    }

    private static BuilderGeneratedProperty propertyFromGetter(MethodSignature method) {
        Preconditions.checkArgument((method != null ? 1 : 0) != 0);
        Preconditions.checkArgument((method.getReturnType() != null ? 1 : 0) != 0);
        Preconditions.checkArgument((method.getName() != null ? 1 : 0) != 0);
        Preconditions.checkArgument((!method.getName().isEmpty() ? 1 : 0) != 0);
        if (method.isDefault()) {
            return null;
        }
        if (!BindingMapping.isGetterMethodName((String)method.getName())) {
            return null;
        }
        String fieldName = StringExtensions.toFirstLower((String)method.getName().substring(GETTER_PREFIX_LENGTH));
        return new BuilderGeneratedProperty(fieldName, method);
    }

    static {
        Method m;
        CLASS = JavaTypeName.create(Class.class);
        DEPRECATED = JavaTypeName.create(Deprecated.class);
        IAE = JavaTypeName.create(IllegalArgumentException.class);
        NPE = JavaTypeName.create(NullPointerException.class);
        NSEE = JavaTypeName.create(NoSuchElementException.class);
        OBJECT = JavaTypeName.create(Object.class);
        OVERRIDE = JavaTypeName.create(Override.class);
        SUPPRESS_WARNINGS = JavaTypeName.create(SuppressWarnings.class);
        VOID = JavaTypeName.create(Void.TYPE);
        JU_ARRAYS = JavaTypeName.create(Arrays.class);
        JU_HASHMAP = JavaTypeName.create(HashMap.class);
        JU_LIST = JavaTypeName.create(List.class);
        JU_MAP = JavaTypeName.create(Map.class);
        JU_OBJECTS = JavaTypeName.create(Objects.class);
        JUR_PATTERN = JavaTypeName.create(Pattern.class);
        GENERATED = JavaTypeName.create(Generated.class);
        NONNULL = JavaTypeName.create((String)"org.eclipse.jdt.annotation", (String)"NonNull");
        NONNULL_BY_DEFAULT = JavaTypeName.create((String)"org.eclipse.jdt.annotation", (String)"NonNullByDefault");
        NULLABLE = JavaTypeName.create((String)"org.eclipse.jdt.annotation", (String)"Nullable");
        CODEHELPERS = JavaTypeName.create(CodeHelpers.class);
        MOREOBJECTS = JavaTypeName.create(MoreObjects.class);
        METHOD_COMPARATOR = new AlphabeticallyTypeMemberComparator<MethodSignature>();
        AMP_MATCHER = CharMatcher.is((char)'&');
        TAIL_COMMENT_PATTERN = Pattern.compile("*/", 16);
        YANG_FORMATTER = DeclaredStatementFormatter.builder().addIgnoredStatement((StatementDefinition)YangStmtMapping.CONTACT).addIgnoredStatement((StatementDefinition)YangStmtMapping.DESCRIPTION).addIgnoredStatement((StatementDefinition)YangStmtMapping.REFERENCE).addIgnoredStatement((StatementDefinition)YangStmtMapping.ORGANIZATION).build();
        GETTER_PREFIX_LENGTH = "get".length();
        try {
            m = Augmentable.class.getDeclaredMethod("augmentation", Class.class);
        }
        catch (NoSuchMethodException e) {
            throw new ExceptionInInitializerError(e);
        }
        AUGMENTATION_RET_TYPE = Type.of((JavaTypeName)JavaTypeName.create(m.getReturnType()));
    }
}

