/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.java.api.generator;

import com.google.common.base.Preconditions;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.model.api.ConcreteType;
import org.opendaylight.mdsal.binding.model.api.GeneratedProperty;
import org.opendaylight.mdsal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.mdsal.binding.model.api.Type;

final class TypeUtils {
    private TypeUtils() {
    }

    static ConcreteType getBaseYangType(@NonNull Type type) {
        if (type instanceof ConcreteType) {
            ConcreteType concrete = (ConcreteType)type;
            return concrete;
        }
        Preconditions.checkArgument((boolean)(type instanceof GeneratedTransferObject), (String)"Unsupported type %s", (Object)type);
        GeneratedTransferObject rootGto = (GeneratedTransferObject)type;
        while (rootGto.getSuperType() != null) {
            rootGto = rootGto.getSuperType();
        }
        for (GeneratedProperty s : rootGto.getProperties()) {
            if (!"value".equals(s.getName())) continue;
            return (ConcreteType)s.getReturnType();
        }
        throw new IllegalArgumentException(String.format("Type %s root %s properties %s do not include \"%s\"", type, rootGto, rootGto.getProperties(), "value"));
    }

    static Type encapsulatedValueType(GeneratedTransferObject gto) {
        return ((GeneratedProperty)gto.findProperty("value").orElseThrow()).getReturnType();
    }
}

