/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.model.api;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Identifier;
import org.opendaylight.yangtools.concepts.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Beta
@NonNullByDefault
public abstract class JavaTypeName
implements Identifier,
Immutable {
    private static final Logger LOG = LoggerFactory.getLogger(JavaTypeName.class);
    private static final long serialVersionUID = 1L;
    private final String simpleName;

    JavaTypeName(String simpleName) {
        Preconditions.checkArgument((!simpleName.isEmpty() ? 1 : 0) != 0);
        this.simpleName = simpleName;
    }

    public static JavaTypeName create(Class<?> clazz) {
        Class<?> enclosing = clazz.getEnclosingClass();
        if (enclosing != null) {
            return JavaTypeName.create(enclosing).createEnclosed(clazz.getSimpleName());
        }
        Package pkg = clazz.getPackage();
        return pkg == null ? new Primitive(clazz.getSimpleName()) : new TopLevel(pkg.getName(), clazz.getSimpleName());
    }

    public static JavaTypeName create(String packageName, String simpleName) {
        return new TopLevel(packageName, simpleName);
    }

    public abstract boolean canCreateEnclosed(String var1);

    public abstract JavaTypeName createEnclosed(String var1);

    public final JavaTypeName createEnclosed(String simpleName, String fallbackSuffix) {
        Preconditions.checkArgument((!simpleName.isEmpty() ? 1 : 0) != 0);
        try {
            return this.createEnclosed(simpleName);
        }
        catch (IllegalArgumentException e) {
            String fallback = simpleName + fallbackSuffix;
            LOG.debug("Failed to create enclosed type '{}', falling back to '{}'", new Object[]{simpleName, fallback, e});
            return this.createEnclosed(fallback);
        }
    }

    public abstract JavaTypeName createSibling(String var1);

    public final String simpleName() {
        return this.simpleName;
    }

    public abstract String packageName();

    public abstract Optional<JavaTypeName> immediatelyEnclosingClass();

    public abstract JavaTypeName topLevelClass();

    public abstract String localName();

    public abstract List<String> localNameComponents();

    public final int hashCode() {
        return Objects.hash(this.simpleName, this.packageName(), this.immediatelyEnclosingClass());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(@Nullable Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof JavaTypeName)) return false;
        JavaTypeName other = (JavaTypeName)obj;
        if (!this.simpleName.equals(other.simpleName)) return false;
        if (!this.packageName().equals(other.packageName())) return false;
        if (!this.immediatelyEnclosingClass().equals(other.immediatelyEnclosingClass())) return false;
        return true;
    }

    public abstract String toString();

    private static final class Primitive
    extends JavaTypeName {
        private static final long serialVersionUID = 1L;

        Primitive(String simpleName) {
            super(simpleName);
        }

        @Override
        public String packageName() {
            return "";
        }

        @Override
        public Optional<JavaTypeName> immediatelyEnclosingClass() {
            return Optional.empty();
        }

        @Override
        public boolean canCreateEnclosed(String simpleName) {
            throw new UnsupportedOperationException("Primitive type " + this.simpleName() + " cannot enclose type " + simpleName);
        }

        @Override
        public JavaTypeName createEnclosed(String simpleName) {
            throw new UnsupportedOperationException("Primitive type " + this.simpleName() + " cannot enclose type " + simpleName);
        }

        @Override
        public String localName() {
            return this.simpleName();
        }

        @Override
        public List<String> localNameComponents() {
            return ImmutableList.of((Object)this.simpleName());
        }

        @Override
        public JavaTypeName createSibling(String simpleName) {
            return new Primitive(simpleName);
        }

        @Override
        public JavaTypeName topLevelClass() {
            return this;
        }

        @Override
        public String toString() {
            return this.simpleName();
        }
    }

    private static final class TopLevel
    extends Reference {
        private static final long serialVersionUID = 1L;
        private final String packageName;

        TopLevel(String packageName, String simpleName) {
            super(simpleName);
            Preconditions.checkArgument((!packageName.isEmpty() ? 1 : 0) != 0);
            this.packageName = packageName;
        }

        @Override
        public String packageName() {
            return this.packageName;
        }

        @Override
        public JavaTypeName createSibling(String simpleName) {
            return new TopLevel(this.packageName, simpleName);
        }

        @Override
        public Optional<JavaTypeName> immediatelyEnclosingClass() {
            return Optional.empty();
        }

        @Override
        public String localName() {
            return this.simpleName();
        }

        @Override
        public List<String> localNameComponents() {
            ArrayList<String> ret = new ArrayList<String>();
            ret.add(this.simpleName());
            return ret;
        }

        @Override
        public JavaTypeName topLevelClass() {
            return this;
        }

        @Override
        StringBuilder appendClass(StringBuilder sb) {
            return sb.append(this.packageName).append('.').append(this.simpleName());
        }
    }

    private static final class Nested
    extends Reference {
        private static final long serialVersionUID = 1L;
        private final Reference immediatelyEnclosingClass;

        Nested(Reference immediatelyEnclosingClass, String simpleName) {
            super(simpleName);
            this.immediatelyEnclosingClass = Objects.requireNonNull(immediatelyEnclosingClass);
        }

        @Override
        public String packageName() {
            return this.immediatelyEnclosingClass.packageName();
        }

        @Override
        public JavaTypeName createSibling(String simpleName) {
            return this.immediatelyEnclosingClass.createEnclosed(simpleName);
        }

        @Override
        public Optional<JavaTypeName> immediatelyEnclosingClass() {
            return Optional.of(this.immediatelyEnclosingClass);
        }

        @Override
        StringBuilder appendClass(StringBuilder sb) {
            return this.immediatelyEnclosingClass.appendClass(sb).append('.').append(this.simpleName());
        }

        @Override
        public boolean canCreateEnclosed(String simpleName) {
            return super.canCreateEnclosed(simpleName) && this.immediatelyEnclosingClass.canCreateEnclosed(simpleName);
        }

        @Override
        public String localName() {
            return this.immediatelyEnclosingClass.localName() + "." + this.simpleName();
        }

        @Override
        public List<String> localNameComponents() {
            List<String> ret = this.immediatelyEnclosingClass.localNameComponents();
            ret.add(this.simpleName());
            return ret;
        }

        @Override
        public JavaTypeName topLevelClass() {
            return this.immediatelyEnclosingClass.topLevelClass();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static abstract class Reference
    extends JavaTypeName {
        private static final long serialVersionUID = 1L;

        Reference(String simpleName) {
            super(simpleName);
        }

        @Override
        public boolean canCreateEnclosed(String simpleName) {
            return !simpleName.equals(this.simpleName());
        }

        @Override
        public final JavaTypeName createEnclosed(String simpleName) {
            this.checkValidName(Objects.requireNonNull(simpleName));
            return new Nested(this, simpleName);
        }

        @Override
        public final String toString() {
            return this.appendClass(new StringBuilder()).toString();
        }

        void checkValidName(String nestedName) {
            Preconditions.checkArgument((boolean)this.canCreateEnclosed(nestedName), (String)"Nested class name %s conflicts with enclosing class %s", (Object)nestedName, (Object)this);
        }

        abstract StringBuilder appendClass(StringBuilder var1);
    }
}

