/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.spec.reflect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;
import org.opendaylight.yangtools.util.ClassLoaderUtils;
import org.opendaylight.yangtools.yang.binding.Action;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.BaseIdentity;
import org.opendaylight.yangtools.yang.binding.BindingContract;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.Rpc;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.binding.YangModelBindingProvider;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BindingReflections {
    private static final Logger LOG = LoggerFactory.getLogger(BindingReflections.class);
    private static final LoadingCache<Class<?>, Optional<QName>> CLASS_TO_QNAME = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(60L, TimeUnit.SECONDS).build((CacheLoader)new ClassToQNameLoader());
    private static final LoadingCache<ClassLoader, ImmutableSet<YangModuleInfo>> MODULE_INFO_CACHE = CacheBuilder.newBuilder().weakKeys().weakValues().build((CacheLoader)new CacheLoader<ClassLoader, ImmutableSet<YangModuleInfo>>(){

        public ImmutableSet<YangModuleInfo> load(ClassLoader key) {
            return BindingReflections.loadModuleInfos(key);
        }
    });

    private BindingReflections() {
    }

    public static Class<? extends Augmentable<?>> findAugmentationTarget(Class<? extends Augmentation<?>> augmentation) {
        Optional opt = ClassLoaderUtils.findFirstGenericArgument(augmentation, Augmentation.class);
        return opt.orElse(null);
    }

    public static QName findQName(Class<?> dataType) {
        return ((Optional)CLASS_TO_QNAME.getUnchecked(dataType)).orElse(null);
    }

    public static boolean isRpcMethod(Method possibleMethod) {
        return possibleMethod != null && RpcService.class.isAssignableFrom(possibleMethod.getDeclaringClass()) && ListenableFuture.class.isAssignableFrom(possibleMethod.getReturnType()) && possibleMethod.getParameterCount() <= 2;
    }

    public static @NonNull QName getQName(BaseIdentity identity) {
        return BindingReflections.getContractQName(identity);
    }

    public static @NonNull QName getQName(Rpc<?, ?> rpc) {
        return BindingReflections.getContractQName(rpc);
    }

    private static @NonNull QName getContractQName(BindingContract<?> contract) {
        return (QName)((Optional)CLASS_TO_QNAME.getUnchecked((Object)contract.implementedInterface())).orElseThrow(() -> new IllegalStateException("Failed to resolve QName of " + contract));
    }

    @Deprecated(since="11.0.3", forRemoval=true)
    public static String getModelRootPackageName(Package pkg) {
        return BindingReflections.getModelRootPackageName(pkg.getName());
    }

    @Deprecated(since="11.0.3", forRemoval=true)
    public static String getModelRootPackageName(String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Package name should not be null.");
        return BindingMapping.getModelRootPackageName(name);
    }

    public static QNameModule getQNameModule(Class<?> clz) {
        if (DataContainer.class.isAssignableFrom(clz) || BaseIdentity.class.isAssignableFrom(clz) || Action.class.isAssignableFrom(clz)) {
            return BindingReflections.findQName(clz).getModule();
        }
        return BindingReflections.getModuleInfo(clz).getName().getModule();
    }

    public static @NonNull YangModuleInfo getModuleInfo(Class<?> cls) {
        Object infoInstance;
        Class<?> moduleInfoClass;
        String packageName = BindingMapping.getModelRootPackageName(cls.getPackage().getName());
        String potentialClassName = BindingReflections.getModuleInfoClassName(packageName);
        try {
            moduleInfoClass = cls.getClassLoader().loadClass(potentialClassName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to load " + potentialClassName, e);
        }
        try {
            infoInstance = moduleInfoClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to get instance of " + moduleInfoClass, e);
        }
        Preconditions.checkState((boolean)(infoInstance instanceof YangModuleInfo), (String)"Unexpected instance %s", (Object)infoInstance);
        return (YangModuleInfo)infoInstance;
    }

    public static @NonNull String getModuleInfoClassName(String packageName) {
        return packageName + ".$YangModuleInfoImpl";
    }

    public static boolean isBindingClass(Class<?> cls) {
        if (DataContainer.class.isAssignableFrom(cls) || Augmentation.class.isAssignableFrom(cls)) {
            return true;
        }
        return cls.getName().startsWith("org.opendaylight.yang.gen.v1");
    }

    public static boolean isNotificationCallback(Method method) {
        Class<?> potentialNotification;
        Preconditions.checkArgument((method != null ? 1 : 0) != 0);
        return method.getName().startsWith("on") && method.getParameterCount() == 1 && BindingReflections.isNotification(potentialNotification = method.getParameterTypes()[0]) && method.getName().equals("on" + potentialNotification.getSimpleName());
    }

    @VisibleForTesting
    static boolean isNotification(Class<?> potentialNotification) {
        Preconditions.checkArgument((potentialNotification != null ? 1 : 0) != 0, (Object)"potentialNotification must not be null.");
        return Notification.class.isAssignableFrom(potentialNotification);
    }

    public static @NonNull ImmutableSet<YangModuleInfo> loadModuleInfos() {
        return BindingReflections.loadModuleInfos(Thread.currentThread().getContextClassLoader());
    }

    public static @NonNull ImmutableSet<YangModuleInfo> loadModuleInfos(ClassLoader loader) {
        ImmutableSet.Builder moduleInfoSet = ImmutableSet.builder();
        ServiceLoader<YangModelBindingProvider> serviceLoader = ServiceLoader.load(YangModelBindingProvider.class, loader);
        for (YangModelBindingProvider bindingProvider : serviceLoader) {
            YangModuleInfo moduleInfo = bindingProvider.getModuleInfo();
            Preconditions.checkState((moduleInfo != null ? 1 : 0) != 0, (String)"Module Info for %s is not available.", bindingProvider.getClass());
            BindingReflections.collectYangModuleInfo(bindingProvider.getModuleInfo(), (ImmutableSet.Builder<YangModuleInfo>)moduleInfoSet);
        }
        return moduleInfoSet.build();
    }

    @Beta
    public static @NonNull ImmutableSet<YangModuleInfo> cacheModuleInfos(ClassLoader loader) {
        return (ImmutableSet)MODULE_INFO_CACHE.getUnchecked((Object)loader);
    }

    private static void collectYangModuleInfo(YangModuleInfo moduleInfo, ImmutableSet.Builder<YangModuleInfo> moduleInfoSet) {
        moduleInfoSet.add((Object)moduleInfo);
        for (YangModuleInfo dependency : moduleInfo.getImportedModules()) {
            BindingReflections.collectYangModuleInfo(dependency, moduleInfoSet);
        }
    }

    public static boolean isRpcType(Class<? extends DataObject> targetType) {
        return DataContainer.class.isAssignableFrom(targetType) && !ChildOf.class.isAssignableFrom(targetType) && !Notification.class.isAssignableFrom(targetType) && (targetType.getName().endsWith("Input") || targetType.getName().endsWith("Output"));
    }

    private static class ClassToQNameLoader
    extends CacheLoader<Class<?>, Optional<QName>> {
        private ClassToQNameLoader() {
        }

        public Optional<QName> load(Class<?> key) throws Exception {
            return ClassToQNameLoader.resolveQNameNoCache(key);
        }

        private static Optional<QName> resolveQNameNoCache(Class<?> key) {
            try {
                Field field;
                try {
                    field = key.getField("QNAME");
                }
                catch (NoSuchFieldException e) {
                    LOG.debug("{} does not have a {} field, falling back to computation", new Object[]{key, "QNAME", e});
                    return Optional.of(ClassToQNameLoader.computeQName(key));
                }
                Object obj = field.get(null);
                if (obj instanceof QName) {
                    QName qname = (QName)obj;
                    return Optional.of(qname);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
                LOG.debug("Unexpected exception during extracting QName for {}", key, (Object)e);
            }
            return Optional.empty();
        }

        private static QName computeQName(Class key) {
            Preconditions.checkArgument((boolean)BindingReflections.isBindingClass(key), (String)"Supplied class %s is not derived from YANG.", (Object)key);
            QName module = BindingReflections.getModuleInfo(key).getName();
            if (Augmentation.class.isAssignableFrom(key)) {
                return module;
            }
            if (BindingReflections.isRpcType(key)) {
                String className = key.getSimpleName();
                if (className.endsWith("Output")) {
                    return YangConstants.operationOutputQName((QNameModule)module.getModule()).intern();
                }
                return YangConstants.operationInputQName((QNameModule)module.getModule()).intern();
            }
            return module;
        }
    }
}

