/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.bug5446.rev151105;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Base64;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;

public class Ipv4AddressBinary
implements ScalarTypeObject<byte[]>,
Serializable {
    private static final long serialVersionUID = 6742369766065856350L;
    private final byte[] _value;

    private static void check_valueLength(byte[] value) {
        int length = value.length;
        if (length == 4) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[4..4]]", (byte[])value);
    }

    @ConstructorParameters(value={"value"})
    public Ipv4AddressBinary(byte[] _value) {
        if (_value != null) {
            Ipv4AddressBinary.check_valueLength(_value);
        }
        CodeHelpers.requireValue((Object)_value);
        this._value = (byte[])_value.clone();
    }

    public Ipv4AddressBinary(Ipv4AddressBinary source) {
        this._value = source._value;
    }

    public static Ipv4AddressBinary getDefaultInstance(String defaultValue) {
        return new Ipv4AddressBinary(Base64.getDecoder().decode(defaultValue));
    }

    public byte[] getValue() {
        return (byte[])this._value.clone();
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((byte[])this._value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Ipv4AddressBinary)) return false;
        Ipv4AddressBinary other = (Ipv4AddressBinary)obj;
        if (!Arrays.equals(this._value, other._value)) return false;
        return true;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(Ipv4AddressBinary.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"value", (byte[])this._value);
        return helper.toString();
    }
}

