/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.bug5446.rev151105;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Base64;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;

public class Ipv6AddressBinary
implements ScalarTypeObject<byte[]>,
Serializable {
    private static final long serialVersionUID = -6932211183560313514L;
    private final byte[] _value;

    private static void check_valueLength(byte[] value) {
        int length = value.length;
        if (length == 16) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[16..16]]", (byte[])value);
    }

    @ConstructorParameters(value={"value"})
    public Ipv6AddressBinary(byte[] _value) {
        if (_value != null) {
            Ipv6AddressBinary.check_valueLength(_value);
        }
        CodeHelpers.requireValue((Object)_value);
        this._value = (byte[])_value.clone();
    }

    public Ipv6AddressBinary(Ipv6AddressBinary source) {
        this._value = source._value;
    }

    public static Ipv6AddressBinary getDefaultInstance(String defaultValue) {
        return new Ipv6AddressBinary(Base64.getDecoder().decode(defaultValue));
    }

    public byte[] getValue() {
        return (byte[])this._value.clone();
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((byte[])this._value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Ipv6AddressBinary)) return false;
        Ipv6AddressBinary other = (Ipv6AddressBinary)obj;
        if (!Arrays.equals(this._value, other._value)) return false;
        return true;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(Ipv6AddressBinary.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"value", (byte[])this._value);
        return helper.toString();
    }
}

