/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.lal.norev.foo;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.lal.norev.foo.Bar;
import org.opendaylight.yang.gen.v1.lal.norev.foo.BarKey;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class BarBuilder {
    private Integer _id;
    private String _name;
    private BarKey key;
    Map<Class<? extends Augmentation<Bar>>, Augmentation<Bar>> augmentation = Map.of();

    public BarBuilder() {
    }

    public BarBuilder(Bar base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Bar>>, Augmentation<Bar>>(aug);
        }
        this.key = base.key();
        this._id = base.getId();
        this._name = base.getName();
    }

    public BarKey key() {
        return this.key;
    }

    public Integer getId() {
        return this._id;
    }

    public String getName() {
        return this._name;
    }

    public <E$$ extends Augmentation<Bar>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public BarBuilder withKey(BarKey key) {
        this.key = key;
        return this;
    }

    public BarBuilder setId(Integer value) {
        this._id = value;
        return this;
    }

    public BarBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public BarBuilder addAugmentation(Augmentation<Bar> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Bar>>, Augmentation<Bar>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public BarBuilder removeAugmentation(Class<? extends Augmentation<Bar>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Bar build() {
        return new BarImpl(this);
    }

    private static final class BarImpl
    extends AbstractAugmentable<Bar>
    implements Bar {
        private final Integer _id;
        private final String _name;
        private final BarKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        BarImpl(BarBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new BarKey(base.getId());
            this._id = this.key.getId();
            this._name = base.getName();
        }

        @Override
        public BarKey key() {
            return this.key;
        }

        @Override
        public Integer getId() {
            return this._id;
        }

        @Override
        public String getName() {
            return this._name;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Bar.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Bar.bindingEquals(this, obj);
        }

        public String toString() {
            return Bar.bindingToString(this);
        }
    }
}

