/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.mdsal.query.norev.first.grp;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.mdsal.query.norev.SecondGrp;
import org.opendaylight.yang.gen.v1.mdsal.query.norev.first.grp.System;
import org.opendaylight.yang.gen.v1.mdsal.query.norev.first.grp.SystemKey;
import org.opendaylight.yang.gen.v1.mdsal.query.norev.second.grp.Alarms;
import org.opendaylight.yang.gen.v1.mdsal.query.norev.second.grp.AlarmsKey;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SystemBuilder {
    private Map<AlarmsKey, Alarms> _alarms;
    private String _alias;
    private String _name;
    private SystemKey key;
    Map<Class<? extends Augmentation<System>>, Augmentation<System>> augmentation = Map.of();

    public SystemBuilder() {
    }

    public SystemBuilder(SecondGrp arg) {
        this._alarms = arg.getAlarms();
    }

    public SystemBuilder(System base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<System>>, Augmentation<System>>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._alarms = base.getAlarms();
        this._alias = base.getAlias();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SecondGrp) {
            SecondGrp castArg = (SecondGrp)arg;
            this._alarms = castArg.getAlarms();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[SecondGrp]");
    }

    public SystemKey key() {
        return this.key;
    }

    public Map<AlarmsKey, Alarms> getAlarms() {
        return this._alarms;
    }

    public String getAlias() {
        return this._alias;
    }

    public String getName() {
        return this._name;
    }

    public <E$$ extends Augmentation<System>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public SystemBuilder withKey(SystemKey key) {
        this.key = key;
        return this;
    }

    public SystemBuilder setAlarms(Map<AlarmsKey, Alarms> values) {
        this._alarms = values;
        return this;
    }

    public SystemBuilder setAlias(String value) {
        this._alias = value;
        return this;
    }

    public SystemBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public SystemBuilder addAugmentation(Augmentation<System> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<System>>, Augmentation<System>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public SystemBuilder removeAugmentation(Class<? extends Augmentation<System>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull System build() {
        return new SystemImpl(this);
    }

    private static final class SystemImpl
    extends AbstractAugmentable<System>
    implements System {
        private final Map<AlarmsKey, Alarms> _alarms;
        private final String _alias;
        private final String _name;
        private final SystemKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        SystemImpl(SystemBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new SystemKey(base.getName());
            this._name = this.key.getName();
            this._alarms = CodeHelpers.emptyToNull(base.getAlarms());
            this._alias = base.getAlias();
        }

        @Override
        public SystemKey key() {
            return this.key;
        }

        @Override
        public Map<AlarmsKey, Alarms> getAlarms() {
            return this._alarms;
        }

        @Override
        public String getAlias() {
            return this._alias;
        }

        @Override
        public String getName() {
            return this._name;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = System.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return System.bindingEquals(this, obj);
        }

        public String toString() {
            return System.bindingToString(this);
        }
    }
}

