/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.mdsal533.norev.foo_cont;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.mdsal533.norev.foo_cont.FooList;
import org.opendaylight.yang.gen.v1.mdsal533.norev.foo_cont.FooListKey;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

public class FooListBuilder {
    private String _name;
    private FooListKey key;
    Map<Class<? extends Augmentation<FooList>>, Augmentation<FooList>> augmentation = Map.of();

    public FooListBuilder() {
    }

    public FooListBuilder(FooList base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FooList>>, Augmentation<FooList>>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
    }

    public FooListKey key() {
        return this.key;
    }

    public String getName() {
        return this._name;
    }

    public <E$$ extends Augmentation<FooList>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public FooListBuilder withKey(FooListKey key) {
        this.key = key;
        return this;
    }

    private static void check_nameLength(String value) {
        int length = value.codePointCount(0, value.length());
        if (length >= 1 && length <= 255) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[1..255]]", (Object)value);
    }

    public FooListBuilder setName(String value) {
        if (value != null) {
            FooListBuilder.check_nameLength(value);
        }
        this._name = value;
        return this;
    }

    public FooListBuilder addAugmentation(Augmentation<FooList> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FooList>>, Augmentation<FooList>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public FooListBuilder removeAugmentation(Class<? extends Augmentation<FooList>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull FooList build() {
        return new FooListImpl(this);
    }

    private static final class FooListImpl
    extends AbstractAugmentable<FooList>
    implements FooList {
        private final String _name;
        private final FooListKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        FooListImpl(FooListBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new FooListKey(base.getName());
            this._name = this.key.getName();
        }

        @Override
        public FooListKey key() {
            return this.key;
        }

        @Override
        public String getName() {
            return this._name;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = FooList.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return FooList.bindingEquals(this, obj);
        }

        public String toString() {
            return FooList.bindingToString(this);
        }
    }
}

