/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.odl.test.binary.key.rev160101;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.odl.test.binary.key.rev160101.BinaryList;
import org.opendaylight.yang.gen.v1.odl.test.binary.key.rev160101.BinaryListKey;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class BinaryListBuilder {
    private String _binaryItem;
    private byte[] _binaryKey;
    private BinaryListKey key;
    Map<Class<? extends Augmentation<BinaryList>>, Augmentation<BinaryList>> augmentation = Map.of();

    public BinaryListBuilder() {
    }

    public BinaryListBuilder(BinaryList base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BinaryList>>, Augmentation<BinaryList>>(aug);
        }
        this.key = base.key();
        this._binaryKey = base.getBinaryKey();
        this._binaryItem = base.getBinaryItem();
    }

    public BinaryListKey key() {
        return this.key;
    }

    public String getBinaryItem() {
        return this._binaryItem;
    }

    public byte[] getBinaryKey() {
        return this._binaryKey == null ? null : (byte[])this._binaryKey.clone();
    }

    public <E$$ extends Augmentation<BinaryList>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public BinaryListBuilder withKey(BinaryListKey key) {
        this.key = key;
        return this;
    }

    public BinaryListBuilder setBinaryItem(String value) {
        this._binaryItem = value;
        return this;
    }

    public BinaryListBuilder setBinaryKey(byte[] value) {
        this._binaryKey = value;
        return this;
    }

    public BinaryListBuilder addAugmentation(Augmentation<BinaryList> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BinaryList>>, Augmentation<BinaryList>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public BinaryListBuilder removeAugmentation(Class<? extends Augmentation<BinaryList>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull BinaryList build() {
        return new BinaryListImpl(this);
    }

    private static final class BinaryListImpl
    extends AbstractAugmentable<BinaryList>
    implements BinaryList {
        private final String _binaryItem;
        private final byte[] _binaryKey;
        private final BinaryListKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        BinaryListImpl(BinaryListBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new BinaryListKey(base.getBinaryKey());
            this._binaryKey = this.key.getBinaryKey();
            this._binaryItem = base.getBinaryItem();
        }

        @Override
        public BinaryListKey key() {
            return this.key;
        }

        @Override
        public String getBinaryItem() {
            return this._binaryItem;
        }

        @Override
        public byte[] getBinaryKey() {
            return this._binaryKey == null ? null : (byte[])this._binaryKey.clone();
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = BinaryList.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return BinaryList.bindingEquals(this, obj);
        }

        public String toString() {
            return BinaryList.bindingToString(this);
        }
    }
}

