/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;

public class BigSignedInteger
implements ScalarTypeObject<Long>,
Serializable {
    private static final long serialVersionUID = -2141338445125261572L;
    private final Long _value;

    private static void check_valueRange(long value) {
        if (value >= -3500000000L && value <= -2500000000L) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[-3500000000..-2500000000]]", (long)value);
    }

    @ConstructorParameters(value={"value"})
    public BigSignedInteger(Long _value) {
        if (_value != null) {
            BigSignedInteger.check_valueRange(_value);
        }
        CodeHelpers.requireValue((Object)_value);
        this._value = _value;
    }

    public BigSignedInteger(BigSignedInteger source) {
        this._value = source._value;
    }

    public static BigSignedInteger getDefaultInstance(String defaultValue) {
        return new BigSignedInteger(Long.valueOf(defaultValue));
    }

    public Long getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof BigSignedInteger)) return false;
        BigSignedInteger other = (BigSignedInteger)obj;
        if (!Objects.equals(this._value, other._value)) return false;
        return true;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(BigSignedInteger.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"value", (Object)this._value);
        return helper.toString();
    }
}

