/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;
import org.opendaylight.yangtools.yang.common.Uint64;

public class BigUnsignedInteger
implements ScalarTypeObject<Uint64>,
Serializable {
    private static final long serialVersionUID = 8470590613314739681L;
    private final Uint64 _value;

    private static void check_valueRange(long value) {
        if (Long.compareUnsigned(value, 4500000000L) >= 0 && Long.compareUnsigned(value, 6500000000L) <= 0) {
            return;
        }
        CodeHelpers.throwInvalidRangeUnsigned((String)"[[4500000000..6500000000]]", (long)value);
    }

    @ConstructorParameters(value={"value"})
    public BigUnsignedInteger(Uint64 _value) {
        if (_value != null) {
            BigUnsignedInteger.check_valueRange(_value.longValue());
        }
        CodeHelpers.requireValue((Object)_value);
        this._value = _value;
    }

    public BigUnsignedInteger(BigUnsignedInteger source) {
        this._value = source._value;
    }

    public static BigUnsignedInteger getDefaultInstance(String defaultValue) {
        return new BigUnsignedInteger(Uint64.valueOf((String)defaultValue));
    }

    public Uint64 getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof BigUnsignedInteger)) return false;
        BigUnsignedInteger other = (BigUnsignedInteger)obj;
        if (!Objects.equals(this._value, other._value)) return false;
        return true;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(BigUnsignedInteger.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"value", (Object)this._value);
        return helper.toString();
    }
}

