/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;

public class MyString
implements ScalarTypeObject<String>,
Serializable {
    private static final long serialVersionUID = -2963492462037607022L;
    public static final List<String> PATTERN_CONSTANTS = ImmutableList.of((Object)"^(?:[a-zA-Z ]+)$");
    private static final Pattern patterns = Pattern.compile(PATTERN_CONSTANTS.get(0));
    private static final String regexes = "[a-zA-Z ]+";
    private final String _value;

    private static void check_valueLength(String value) {
        int length = value.codePointCount(0, value.length());
        if (length >= 1 && length <= 30) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[1..30]]", (Object)value);
    }

    @ConstructorParameters(value={"value"})
    public MyString(String _value) {
        if (_value != null) {
            MyString.check_valueLength(_value);
        }
        CodeHelpers.requireValue((Object)_value);
        CodeHelpers.checkPattern((String)_value, (Pattern)patterns, (String)regexes);
        this._value = _value;
    }

    public MyString(MyString source) {
        this._value = source._value;
    }

    public static MyString getDefaultInstance(String defaultValue) {
        return new MyString(defaultValue);
    }

    public String getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof MyString)) return false;
        MyString other = (MyString)obj;
        if (!Objects.equals(this._value, other._value)) return false;
        return true;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(MyString.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"value", (Object)this._value);
        return helper.toString();
    }
}

