/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;

public class NormalSignedInteger
implements ScalarTypeObject<Integer>,
Serializable {
    private static final long serialVersionUID = -2395315814513704599L;
    private final Integer _value;

    private static void check_valueRange(int value) {
        if (value >= -250000 && value <= -50000) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[-250000..-50000]]", (int)value);
    }

    @ConstructorParameters(value={"value"})
    public NormalSignedInteger(Integer _value) {
        if (_value != null) {
            NormalSignedInteger.check_valueRange(_value);
        }
        CodeHelpers.requireValue((Object)_value);
        this._value = _value;
    }

    public NormalSignedInteger(NormalSignedInteger source) {
        this._value = source._value;
    }

    public static NormalSignedInteger getDefaultInstance(String defaultValue) {
        return new NormalSignedInteger(Integer.valueOf(defaultValue));
    }

    public Integer getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof NormalSignedInteger)) return false;
        NormalSignedInteger other = (NormalSignedInteger)obj;
        if (!Objects.equals(this._value, other._value)) return false;
        return true;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(NormalSignedInteger.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"value", (Object)this._value);
        return helper.toString();
    }
}

