/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;
import org.opendaylight.yangtools.yang.common.Uint32;

public class NormalUnsignedInteger
implements ScalarTypeObject<Uint32>,
Serializable {
    private static final long serialVersionUID = -5496765833633222762L;
    private final Uint32 _value;

    private static void check_valueRange(long value) {
        if (value >= 70000L && value <= 4200000000L) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[70000..4200000000]]", (long)value);
    }

    @ConstructorParameters(value={"value"})
    public NormalUnsignedInteger(Uint32 _value) {
        if (_value != null) {
            NormalUnsignedInteger.check_valueRange(_value.longValue());
        }
        CodeHelpers.requireValue((Object)_value);
        this._value = _value;
    }

    public NormalUnsignedInteger(NormalUnsignedInteger source) {
        this._value = source._value;
    }

    public static NormalUnsignedInteger getDefaultInstance(String defaultValue) {
        return new NormalUnsignedInteger(Uint32.valueOf((String)defaultValue));
    }

    public Uint32 getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof NormalUnsignedInteger)) return false;
        NormalUnsignedInteger other = (NormalUnsignedInteger)obj;
        if (!Objects.equals(this._value, other._value)) return false;
        return true;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(NormalUnsignedInteger.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"value", (Object)this._value);
        return helper.toString();
    }
}

