/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;

public class SmallSignedInteger
implements ScalarTypeObject<Short>,
Serializable {
    private static final long serialVersionUID = -937707059156294901L;
    private final Short _value;

    private static void check_valueRange(short value) {
        if (value >= -25000 && value <= -9000) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[-25000..-9000]]", (int)value);
    }

    @ConstructorParameters(value={"value"})
    public SmallSignedInteger(Short _value) {
        if (_value != null) {
            SmallSignedInteger.check_valueRange(_value);
        }
        CodeHelpers.requireValue((Object)_value);
        this._value = _value;
    }

    public SmallSignedInteger(SmallSignedInteger source) {
        this._value = source._value;
    }

    public static SmallSignedInteger getDefaultInstance(String defaultValue) {
        return new SmallSignedInteger(Short.valueOf(defaultValue));
    }

    public Short getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof SmallSignedInteger)) return false;
        SmallSignedInteger other = (SmallSignedInteger)obj;
        if (!Objects.equals(this._value, other._value)) return false;
        return true;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(SmallSignedInteger.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"value", (Object)this._value);
        return helper.toString();
    }
}

