/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;
import org.opendaylight.yangtools.yang.common.Uint16;

public class SmallUnsignedInteger
implements ScalarTypeObject<Uint16>,
Serializable {
    private static final long serialVersionUID = 1353693694953910989L;
    private final Uint16 _value;

    private static void check_valueRange(int value) {
        if (value >= 9000 && value <= 60000) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[9000..60000]]", (int)value);
    }

    @ConstructorParameters(value={"value"})
    public SmallUnsignedInteger(Uint16 _value) {
        if (_value != null) {
            SmallUnsignedInteger.check_valueRange(_value.intValue());
        }
        CodeHelpers.requireValue((Object)_value);
        this._value = _value;
    }

    public SmallUnsignedInteger(SmallUnsignedInteger source) {
        this._value = source._value;
    }

    public static SmallUnsignedInteger getDefaultInstance(String defaultValue) {
        return new SmallUnsignedInteger(Uint16.valueOf((String)defaultValue));
    }

    public Uint16 getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof SmallUnsignedInteger)) return false;
        SmallUnsignedInteger other = (SmallUnsignedInteger)obj;
        if (!Objects.equals(this._value, other._value)) return false;
        return true;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(SmallUnsignedInteger.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"value", (Object)this._value);
        return helper.toString();
    }
}

