/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;

public class TinySignedInteger
implements ScalarTypeObject<Byte>,
Serializable {
    private static final long serialVersionUID = 2024832163017202576L;
    private final Byte _value;

    private static void check_valueRange(byte value) {
        if (value >= -20 && value <= -1) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[-20..-1]]", (int)value);
    }

    @ConstructorParameters(value={"value"})
    public TinySignedInteger(Byte _value) {
        if (_value != null) {
            TinySignedInteger.check_valueRange(_value);
        }
        CodeHelpers.requireValue((Object)_value);
        this._value = _value;
    }

    public TinySignedInteger(TinySignedInteger source) {
        this._value = source._value;
    }

    public static TinySignedInteger getDefaultInstance(String defaultValue) {
        return new TinySignedInteger(Byte.valueOf(defaultValue));
    }

    public Byte getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof TinySignedInteger)) return false;
        TinySignedInteger other = (TinySignedInteger)obj;
        if (!Objects.equals(this._value, other._value)) return false;
        return true;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(TinySignedInteger.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"value", (Object)this._value);
        return helper.toString();
    }
}

