/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns._default.value.test.norev;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;
import org.opendaylight.yangtools.yang.common.Uint8;

public class TinyUnsignedInteger
implements ScalarTypeObject<Uint8>,
Serializable {
    private static final long serialVersionUID = 4207213715126438914L;
    private final Uint8 _value;

    private static void check_valueRange(short value) {
        if (value >= 15 && value <= 220) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[15..220]]", (int)value);
    }

    @ConstructorParameters(value={"value"})
    public TinyUnsignedInteger(Uint8 _value) {
        if (_value != null) {
            TinyUnsignedInteger.check_valueRange(_value.shortValue());
        }
        CodeHelpers.requireValue((Object)_value);
        this._value = _value;
    }

    public TinyUnsignedInteger(TinyUnsignedInteger source) {
        this._value = source._value;
    }

    public static TinyUnsignedInteger getDefaultInstance(String defaultValue) {
        return new TinyUnsignedInteger(Uint8.valueOf((String)defaultValue));
    }

    public Uint8 getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof TinyUnsignedInteger)) return false;
        TinyUnsignedInteger other = (TinyUnsignedInteger)obj;
        if (!Objects.equals(this._value, other._value)) return false;
        return true;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(TinyUnsignedInteger.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"value", (Object)this._value);
        return helper.toString();
    }
}

