/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.test.leaf.caching.codec.rev190201;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;

public class MyType
implements ScalarTypeObject<String>,
Serializable {
    private static final long serialVersionUID = 3136261909751257446L;
    private final String _value;

    private static void check_valueLength(String value) {
        int length = value.codePointCount(0, value.length());
        if (length >= 2 && length <= 5) {
            return;
        }
        CodeHelpers.throwInvalidLength((String)"[[2..5]]", (Object)value);
    }

    @ConstructorParameters(value={"value"})
    public MyType(String _value) {
        if (_value != null) {
            MyType.check_valueLength(_value);
        }
        CodeHelpers.requireValue((Object)_value);
        this._value = _value;
    }

    public MyType(MyType source) {
        this._value = source._value;
    }

    public static MyType getDefaultInstance(String defaultValue) {
        return new MyType(defaultValue);
    }

    public String getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof MyType)) return false;
        MyType other = (MyType)obj;
        if (!Objects.equals(this._value, other._value)) return false;
        return true;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(MyType.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"value", (Object)this._value);
        return helper.toString();
    }
}

