/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.test.opendaylight.mdsal298.rev180129;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.test.opendaylight.mdsal298.rev180129.Container;
import org.opendaylight.yang.gen.v1.urn.test.opendaylight.mdsal298.rev180129.container.Keyed;
import org.opendaylight.yang.gen.v1.urn.test.opendaylight.mdsal298.rev180129.container.Unkeyed;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

public class ContainerBuilder {
    private List<Keyed> _keyed;
    private List<Unkeyed> _unkeyed;
    Map<Class<? extends Augmentation<Container>>, Augmentation<Container>> augmentation = Map.of();

    public ContainerBuilder() {
    }

    public ContainerBuilder(Container base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Container>>, Augmentation<Container>>(aug);
        }
        this._keyed = base.getKeyed();
        this._unkeyed = base.getUnkeyed();
    }

    public List<Keyed> getKeyed() {
        return this._keyed;
    }

    public List<Unkeyed> getUnkeyed() {
        return this._unkeyed;
    }

    public <E$$ extends Augmentation<Container>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ContainerBuilder setKeyed(List<Keyed> values) {
        this._keyed = values;
        return this;
    }

    public ContainerBuilder setUnkeyed(List<Unkeyed> values) {
        this._unkeyed = values;
        return this;
    }

    public ContainerBuilder addAugmentation(Augmentation<Container> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Container>>, Augmentation<Container>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ContainerBuilder removeAugmentation(Class<? extends Augmentation<Container>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Container build() {
        return new ContainerImpl(this);
    }

    private static final class ContainerImpl
    extends AbstractAugmentable<Container>
    implements Container {
        private final List<Keyed> _keyed;
        private final List<Unkeyed> _unkeyed;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ContainerImpl(ContainerBuilder base) {
            super(base.augmentation);
            this._keyed = CodeHelpers.emptyToNull(base.getKeyed());
            this._unkeyed = CodeHelpers.emptyToNull(base.getUnkeyed());
        }

        @Override
        public List<Keyed> getKeyed() {
            return this._keyed;
        }

        @Override
        public List<Unkeyed> getUnkeyed() {
            return this._unkeyed;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Container.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Container.bindingEquals(this, obj);
        }

        public String toString() {
            return Container.bindingToString(this);
        }
    }
}

