/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.test.opendaylight.mdsal483.norev;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.test.opendaylight.mdsal483.norev.Bar;
import org.opendaylight.yang.gen.v1.urn.test.opendaylight.mdsal483.norev.BarKey;
import org.opendaylight.yang.gen.v1.urn.test.opendaylight.mdsal483.norev.Foo;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.Uint64;

public class BarBuilder {
    private Uint64 _one;
    private Foo _two;
    private BarKey key;
    Map<Class<? extends Augmentation<Bar>>, Augmentation<Bar>> augmentation = Map.of();

    public BarBuilder() {
    }

    public BarBuilder(Bar base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Bar>>, Augmentation<Bar>>(aug);
        }
        this.key = base.key();
        this._one = base.getOne();
        this._two = base.getTwo();
    }

    public BarKey key() {
        return this.key;
    }

    public Uint64 getOne() {
        return this._one;
    }

    public Foo getTwo() {
        return this._two;
    }

    public <E$$ extends Augmentation<Bar>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public BarBuilder withKey(BarKey key) {
        this.key = key;
        return this;
    }

    public BarBuilder setOne(Uint64 value) {
        this._one = value;
        return this;
    }

    public BarBuilder setTwo(Foo value) {
        this._two = value;
        return this;
    }

    public BarBuilder addAugmentation(Augmentation<Bar> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Bar>>, Augmentation<Bar>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public BarBuilder removeAugmentation(Class<? extends Augmentation<Bar>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Bar build() {
        return new BarImpl(this);
    }

    private static final class BarImpl
    extends AbstractAugmentable<Bar>
    implements Bar {
        private final Uint64 _one;
        private final Foo _two;
        private final BarKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        BarImpl(BarBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new BarKey(base.getOne(), base.getTwo());
            this._one = this.key.getOne();
            this._two = this.key.getTwo();
        }

        @Override
        public BarKey key() {
            return this.key;
        }

        @Override
        public Uint64 getOne() {
            return this._one;
        }

        @Override
        public Foo getTwo() {
            return this._two;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Bar.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Bar.bindingEquals(this, obj);
        }

        public String toString() {
            return Bar.bindingToString(this);
        }
    }
}

