/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.test.unsigned.rev180408;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.test.unsigned.rev180408.MyCont;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;

public class MyContBuilder {
    private Short _int16Leaf;
    private Integer _int32Leaf;
    private Long _int64Leaf;
    private Byte _int8Leaf;
    private Uint16 _uint16Leaf;
    private Uint32 _uint32Leaf;
    private Uint64 _uint64Leaf;
    private Uint8 _uint8Leaf;
    Map<Class<? extends Augmentation<MyCont>>, Augmentation<MyCont>> augmentation = Map.of();

    public MyContBuilder() {
    }

    public MyContBuilder(MyCont base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MyCont>>, Augmentation<MyCont>>(aug);
        }
        this._int16Leaf = base.getInt16Leaf();
        this._int32Leaf = base.getInt32Leaf();
        this._int64Leaf = base.getInt64Leaf();
        this._int8Leaf = base.getInt8Leaf();
        this._uint16Leaf = base.getUint16Leaf();
        this._uint32Leaf = base.getUint32Leaf();
        this._uint64Leaf = base.getUint64Leaf();
        this._uint8Leaf = base.getUint8Leaf();
    }

    public static @NonNull MyCont empty() {
        return LazyEmpty.INSTANCE;
    }

    public Short getInt16Leaf() {
        return this._int16Leaf;
    }

    public Integer getInt32Leaf() {
        return this._int32Leaf;
    }

    public Long getInt64Leaf() {
        return this._int64Leaf;
    }

    public Byte getInt8Leaf() {
        return this._int8Leaf;
    }

    public Uint16 getUint16Leaf() {
        return this._uint16Leaf;
    }

    public Uint32 getUint32Leaf() {
        return this._uint32Leaf;
    }

    public Uint64 getUint64Leaf() {
        return this._uint64Leaf;
    }

    public Uint8 getUint8Leaf() {
        return this._uint8Leaf;
    }

    public <E$$ extends Augmentation<MyCont>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    private static void checkInt16LeafRange(short value) {
        if (value >= -2 && value <= 2000) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[-2..2000]]", (int)value);
    }

    public MyContBuilder setInt16Leaf(Short value) {
        if (value != null) {
            MyContBuilder.checkInt16LeafRange(value);
        }
        this._int16Leaf = value;
        return this;
    }

    private static void checkInt32LeafRange(int value) {
        if (value >= -3 && value <= 30000) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[-3..30000]]", (int)value);
    }

    public MyContBuilder setInt32Leaf(Integer value) {
        if (value != null) {
            MyContBuilder.checkInt32LeafRange(value);
        }
        this._int32Leaf = value;
        return this;
    }

    private static void checkInt64LeafRange(long value) {
        if (value >= -4L && value <= 40000L) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[-4..40000]]", (long)value);
    }

    public MyContBuilder setInt64Leaf(Long value) {
        if (value != null) {
            MyContBuilder.checkInt64LeafRange(value);
        }
        this._int64Leaf = value;
        return this;
    }

    private static void checkInt8LeafRange(byte value) {
        if (value >= -1 && value <= 100) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[-1..100]]", (int)value);
    }

    public MyContBuilder setInt8Leaf(Byte value) {
        if (value != null) {
            MyContBuilder.checkInt8LeafRange(value);
        }
        this._int8Leaf = value;
        return this;
    }

    private static void checkUint16LeafRange(int value) {
        if (value >= 2 && value <= 2000) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[2..2000]]", (int)value);
    }

    public MyContBuilder setUint16Leaf(Uint16 value) {
        if (value != null) {
            MyContBuilder.checkUint16LeafRange(value.intValue());
        }
        this._uint16Leaf = value;
        return this;
    }

    private static void checkUint32LeafRange(long value) {
        if (value >= 3L && value <= 30000L) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[3..30000]]", (long)value);
    }

    public MyContBuilder setUint32Leaf(Uint32 value) {
        if (value != null) {
            MyContBuilder.checkUint32LeafRange(value.longValue());
        }
        this._uint32Leaf = value;
        return this;
    }

    private static void checkUint64LeafRange(long value) {
        if (Long.compareUnsigned(value, 4L) >= 0 && Long.compareUnsigned(value, 40000L) <= 0) {
            return;
        }
        CodeHelpers.throwInvalidRangeUnsigned((String)"[[4..40000]]", (long)value);
    }

    public MyContBuilder setUint64Leaf(Uint64 value) {
        if (value != null) {
            MyContBuilder.checkUint64LeafRange(value.longValue());
        }
        this._uint64Leaf = value;
        return this;
    }

    private static void checkUint8LeafRange(short value) {
        if (value >= 1 && value <= 100) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[1..100]]", (int)value);
    }

    public MyContBuilder setUint8Leaf(Uint8 value) {
        if (value != null) {
            MyContBuilder.checkUint8LeafRange(value.shortValue());
        }
        this._uint8Leaf = value;
        return this;
    }

    public MyContBuilder addAugmentation(Augmentation<MyCont> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MyCont>>, Augmentation<MyCont>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public MyContBuilder removeAugmentation(Class<? extends Augmentation<MyCont>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull MyCont build() {
        return new MyContImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull MyCont INSTANCE = new MyContBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class MyContImpl
    extends AbstractAugmentable<MyCont>
    implements MyCont {
        private final Short _int16Leaf;
        private final Integer _int32Leaf;
        private final Long _int64Leaf;
        private final Byte _int8Leaf;
        private final Uint16 _uint16Leaf;
        private final Uint32 _uint32Leaf;
        private final Uint64 _uint64Leaf;
        private final Uint8 _uint8Leaf;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MyContImpl(MyContBuilder base) {
            super(base.augmentation);
            this._int16Leaf = base.getInt16Leaf();
            this._int32Leaf = base.getInt32Leaf();
            this._int64Leaf = base.getInt64Leaf();
            this._int8Leaf = base.getInt8Leaf();
            this._uint16Leaf = base.getUint16Leaf();
            this._uint32Leaf = base.getUint32Leaf();
            this._uint64Leaf = base.getUint64Leaf();
            this._uint8Leaf = base.getUint8Leaf();
        }

        @Override
        public Short getInt16Leaf() {
            return this._int16Leaf;
        }

        @Override
        public Integer getInt32Leaf() {
            return this._int32Leaf;
        }

        @Override
        public Long getInt64Leaf() {
            return this._int64Leaf;
        }

        @Override
        public Byte getInt8Leaf() {
            return this._int8Leaf;
        }

        @Override
        public Uint16 getUint16Leaf() {
            return this._uint16Leaf;
        }

        @Override
        public Uint32 getUint32Leaf() {
            return this._uint32Leaf;
        }

        @Override
        public Uint64 getUint64Leaf() {
            return this._uint64Leaf;
        }

        @Override
        public Uint8 getUint8Leaf() {
            return this._uint8Leaf;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = MyCont.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return MyCont.bindingEquals(this, obj);
        }

        public String toString() {
            return MyCont.bindingToString(this);
        }
    }
}

