/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.testutils;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.ReadWriteTransaction;
import org.opendaylight.mdsal.binding.api.WriteTransaction;
import org.opendaylight.mdsal.binding.spi.ForwardingDataBroker;
import org.opendaylight.mdsal.binding.spi.ForwardingReadWriteTransaction;
import org.opendaylight.mdsal.binding.spi.ForwardingWriteTransaction;
import org.opendaylight.mdsal.binding.testutils.DataBrokerFailures;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.common.api.ReadFailedException;
import org.opendaylight.mdsal.common.api.TransactionCommitFailedException;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataBrokerFailuresImpl
extends ForwardingDataBroker
implements DataBrokerFailures {
    private static final Logger LOG = LoggerFactory.getLogger(DataBrokerFailuresImpl.class);
    private final DataBroker delegate;
    private volatile @Nullable ReadFailedException readException;
    private volatile @Nullable TransactionCommitFailedException commitException;
    private final AtomicInteger howManyFailingReads = new AtomicInteger();
    private final AtomicInteger howManyFailingCommits = new AtomicInteger();
    private boolean commitAndThrowException = false;

    public DataBrokerFailuresImpl(DataBroker delegate) {
        this.delegate = delegate;
    }

    protected DataBroker delegate() {
        return this.delegate;
    }

    @Override
    public void failReads(ReadFailedException exception) {
        this.unfailReads();
        this.readException = Objects.requireNonNull(exception, "exception == null");
    }

    @Override
    public void failReads(int howManyTimes, ReadFailedException exception) {
        this.unfailReads();
        this.howManyFailingReads.set(howManyTimes);
        this.readException = Objects.requireNonNull(exception, "exception == null");
    }

    @Override
    public void failCommits(TransactionCommitFailedException exception) {
        this.unfailCommits();
        this.commitException = Objects.requireNonNull(exception, "exception == null");
    }

    @Override
    public void failCommits(int howManyTimes, TransactionCommitFailedException exception) {
        this.howManyFailingCommits.set(howManyTimes);
        this.commitException = Objects.requireNonNull(exception, "exception == null");
    }

    @Override
    public void unfailReads() {
        this.readException = null;
        this.howManyFailingReads.set(-1);
    }

    @Override
    public void unfailCommits() {
        this.commitException = null;
        this.howManyFailingCommits.set(-1);
        this.commitAndThrowException = false;
    }

    @Override
    public void failButCommitAnyway() {
        this.unfailCommits();
        this.commitException = new TransactionCommitFailedException("caused by simulated AskTimeoutException", new RpcError[0]);
        this.commitAndThrowException = true;
    }

    private FluentFuture<? extends CommitInfo> handleCommit(Supplier<FluentFuture<? extends CommitInfo>> commitMethod) {
        if (this.howManyFailingCommits.decrementAndGet() == -1) {
            this.commitException = null;
        }
        if (this.commitException == null) {
            return commitMethod.get();
        }
        if (this.commitAndThrowException) {
            try {
                commitMethod.get().get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.warn("Exception while waiting for committed transaction", (Throwable)e);
            }
        }
        return FluentFuture.from((ListenableFuture)Futures.immediateFailedFuture((Throwable)this.commitException));
    }

    public <T extends DataObject> FluentFuture<Optional<T>> handleRead(BiFunction<LogicalDatastoreType, InstanceIdentifier<T>, FluentFuture<Optional<T>>> readMethod, LogicalDatastoreType store, InstanceIdentifier<T> path) {
        if (this.howManyFailingReads.decrementAndGet() == -1) {
            this.readException = null;
        }
        if (this.readException == null) {
            return readMethod.apply(store, path);
        }
        return FluentFuture.from((ListenableFuture)Futures.immediateFailedFuture((Throwable)this.readException));
    }

    public ReadWriteTransaction newReadWriteTransaction() {
        return new ForwardingReadWriteTransaction(this.delegate.newReadWriteTransaction()){

            public <T extends DataObject> FluentFuture<Optional<T>> read(LogicalDatastoreType store, InstanceIdentifier<T> path) {
                return DataBrokerFailuresImpl.this.handleRead((x$0, x$1) -> super.read(x$0, x$1), store, path);
            }

            public FluentFuture<? extends CommitInfo> commit() {
                return DataBrokerFailuresImpl.this.handleCommit(() -> super.commit());
            }
        };
    }

    public WriteTransaction newWriteOnlyTransaction() {
        return new ForwardingWriteTransaction(this.delegate.newWriteOnlyTransaction()){

            public FluentFuture<? extends CommitInfo> commit() {
                return DataBrokerFailuresImpl.this.handleCommit(() -> super.commit());
            }
        };
    }
}

