/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.testutils;

import com.google.common.annotations.Beta;
import com.google.common.base.Throwables;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.adapter.test.AbstractConcurrentDataBrokerTest;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.mdsal.dom.broker.DOMNotificationRouter;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContextProvider;

@Beta
public class DataBrokerTestModule {
    private final boolean useMTDataTreeChangeListenerExecutor;
    private AbstractConcurrentDataBrokerTest dataBrokerTest;

    public DataBrokerTestModule(boolean useMTDataTreeChangeListenerExecutor) {
        this.useMTDataTreeChangeListenerExecutor = useMTDataTreeChangeListenerExecutor;
    }

    public static DataBroker dataBroker() {
        return new DataBrokerTestModule(false).getDataBroker();
    }

    public DataBroker getDataBroker() {
        try {
            this.dataBrokerTest = new AbstractConcurrentDataBrokerTest(this.useMTDataTreeChangeListenerExecutor){};
            this.dataBrokerTest.setup();
            return this.dataBrokerTest.getDataBroker();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public DOMDataBroker getDOMDataBroker() {
        return this.dataBrokerTest.getDomBroker();
    }

    public CurrentAdapterSerializer getBindingToNormalizedNodeCodec() {
        return this.dataBrokerTest.getDataBrokerTestCustomizer().getAdapterContext().currentSerializer();
    }

    public DOMNotificationRouter getDOMNotificationRouter() {
        return this.dataBrokerTest.getDataBrokerTestCustomizer().getDomNotificationRouter();
    }

    public DOMSchemaService getSchemaService() {
        return this.dataBrokerTest.getDataBrokerTestCustomizer().getSchemaService();
    }

    public EffectiveModelContextProvider getSchemaContextProvider() {
        return () -> ((DOMSchemaService)this.dataBrokerTest.getDataBrokerTestCustomizer().getSchemaService()).getGlobalContext();
    }
}

