/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.testutils;

import com.github.difflib.DiffUtils;
import com.github.difflib.UnifiedDiffUtils;
import com.github.difflib.patch.Patch;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.List;

final class DiffUtil {
    private static final int MAX_DIFFS = 1;
    private static final int CONTEXT_LINES = 3;
    private static final Splitter SPLITTER = Splitter.on((String)System.getProperty("line.separator"));
    private static final Joiner JOINER = Joiner.on((String)System.getProperty("line.separator"));

    private DiffUtil() {
    }

    static String diff(String expectedText, String actualText) {
        List originalLines = SPLITTER.splitToList((CharSequence)expectedText);
        List revisedLines = SPLITTER.splitToList((CharSequence)actualText);
        Patch patch = DiffUtils.diff((List)originalLines, (List)revisedLines);
        List diff = UnifiedDiffUtils.generateUnifiedDiff((String)"expected", (String)"actual", (List)originalLines, (Patch)patch, (int)3);
        String header = "";
        int deltas = patch.getDeltas().size();
        if (deltas > 1) {
            header = String.format("(Too many differences (%d); only showing first %d)%n", deltas, 1);
            diff = diff.subList(0, 1);
        }
        return header + JOINER.join((Iterable)diff);
    }
}

