/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.util;

import com.google.common.annotations.Beta;
import java.util.Objects;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Beta
public abstract class Datastore {
    public static final Operational OPERATIONAL = new Operational();
    public static final Configuration CONFIGURATION = new Configuration();
    private final LogicalDatastoreType type;

    private Datastore(LogicalDatastoreType type) {
        this.type = Objects.requireNonNull(type);
    }

    public LogicalDatastoreType type() {
        return this.type;
    }

    public static Datastore ofType(LogicalDatastoreType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case LogicalDatastoreType.CONFIGURATION -> CONFIGURATION;
            case LogicalDatastoreType.OPERATIONAL -> OPERATIONAL;
        };
    }

    public static final class Configuration
    extends Datastore {
        private Configuration() {
            super(LogicalDatastoreType.CONFIGURATION);
        }
    }

    public static final class Operational
    extends Datastore {
        private Operational() {
            super(LogicalDatastoreType.OPERATIONAL);
        }
    }
}

