/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.util;

import com.google.common.util.concurrent.FluentFuture;
import org.opendaylight.mdsal.binding.api.QueryOperations;
import org.opendaylight.mdsal.binding.api.Transaction;
import org.opendaylight.mdsal.binding.api.query.QueryExpression;
import org.opendaylight.mdsal.binding.api.query.QueryResult;
import org.opendaylight.mdsal.binding.spi.ForwardingTransaction;
import org.opendaylight.mdsal.binding.util.Datastore;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yangtools.yang.binding.DataObject;

abstract class TypedTransaction<D extends Datastore, X extends Transaction>
extends ForwardingTransaction {
    private final LogicalDatastoreType datastoreType;
    private final X delegate;

    TypedTransaction(D datastore, X delegate) {
        this.datastoreType = ((Datastore)datastore).type();
        this.delegate = delegate;
    }

    protected final X delegate() {
        return this.delegate;
    }

    final LogicalDatastoreType getDatastoreType() {
        return this.datastoreType;
    }

    final <T extends DataObject> FluentFuture<QueryResult<T>> doExecute(QueryExpression<T> query) {
        X x = this.delegate;
        if (x instanceof QueryOperations) {
            QueryOperations queryOps = (QueryOperations)x;
            return queryOps.execute(this.datastoreType, query);
        }
        throw new UnsupportedOperationException("Query execution requires backend support");
    }
}

