/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.common.api;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.OnCommitCallback;
import org.opendaylight.mdsal.common.api.TransactionCommitFailedException;
import org.opendaylight.yangtools.yang.common.RpcError;

public interface OnCommitFutureCallback
extends OnCommitCallback,
FutureCallback<CommitInfo> {
    default public void onFailure(Throwable cause) {
        this.onFailure(OnCommitFutureCallback.map(cause));
    }

    private static @NonNull TransactionCommitFailedException map(Throwable cause) {
        Throwable throwable = cause;
        Objects.requireNonNull(throwable);
        Throwable throwable2 = throwable;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TransactionCommitFailedException.class, CancellationException.class, InterruptedException.class, ExecutionException.class, UncheckedExecutionException.class}, (Object)throwable2, n)) {
            case 0 -> {
                TransactionCommitFailedException tcfe;
                yield tcfe = (TransactionCommitFailedException)((Object)throwable2);
            }
            case 1 -> {
                CancellationException ce = (CancellationException)throwable2;
                yield OnCommitFutureCallback.newWithCause("was cancelled.", ce);
            }
            case 2 -> {
                InterruptedException ie = (InterruptedException)throwable2;
                yield OnCommitFutureCallback.newWithCause("was interupted.", ie);
            }
            case 3 -> {
                ExecutionException ee = (ExecutionException)throwable2;
                yield OnCommitFutureCallback.map(ee.getCause());
            }
            case 4 -> {
                UncheckedExecutionException uee = (UncheckedExecutionException)throwable2;
                yield OnCommitFutureCallback.map(uee.getCause());
            }
            default -> OnCommitFutureCallback.newWithCause("encountered an unexpected failure", cause);
        };
    }

    private static @NonNull TransactionCommitFailedException newWithCause(String what, Throwable cause) {
        return new TransactionCommitFailedException("commit " + what, cause, new RpcError[0]);
    }
}

