/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.api;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.FluentFuture;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.common.api.DataValidationFailedException;
import org.opendaylight.mdsal.common.api.PostCanCommitStep;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCandidate;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yangtools.concepts.HierarchicalIdentifier;
import org.opendaylight.yangtools.util.concurrent.ExceptionMapper;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

@Beta
public interface DOMDataTreeCommitCohort {
    public @NonNull FluentFuture<PostCanCommitStep> canCommit(@NonNull Object var1, @NonNull SchemaContext var2, @NonNull Collection<DOMDataTreeCandidate> var3);

    public static class DataValidationFailedExceptionMapper
    extends ExceptionMapper<DataValidationFailedException> {
        private final @NonNull DOMDataTreeIdentifier failedTreeId;

        public DataValidationFailedExceptionMapper(String opName, DOMDataTreeIdentifier failedTreeId) {
            super(opName, DataValidationFailedException.class);
            this.failedTreeId = Objects.requireNonNull(failedTreeId);
        }

        protected DataValidationFailedException newWithCause(String message, Throwable cause) {
            return new DataValidationFailedException(DOMDataTreeIdentifier.class, (HierarchicalIdentifier)this.failedTreeId, message, cause);
        }
    }
}

