/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.api;

import com.google.common.base.MoreObjects;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yangtools.concepts.HierarchicalIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

@NonNullByDefault
public final class DOMDataTreeIdentifier
implements HierarchicalIdentifier<DOMDataTreeIdentifier>,
Comparable<DOMDataTreeIdentifier> {
    private static final long serialVersionUID = 1L;
    private final YangInstanceIdentifier rootIdentifier;
    private final LogicalDatastoreType datastoreType;

    public DOMDataTreeIdentifier(LogicalDatastoreType datastoreType, YangInstanceIdentifier rootIdentifier) {
        this.datastoreType = Objects.requireNonNull(datastoreType);
        this.rootIdentifier = Objects.requireNonNull(rootIdentifier);
    }

    public LogicalDatastoreType getDatastoreType() {
        return this.datastoreType;
    }

    public YangInstanceIdentifier getRootIdentifier() {
        return this.rootIdentifier;
    }

    public boolean contains(DOMDataTreeIdentifier other) {
        return this.datastoreType == other.datastoreType && this.rootIdentifier.contains(other.rootIdentifier);
    }

    public DOMDataTreeIdentifier toOptimized() {
        YangInstanceIdentifier opt = this.rootIdentifier.toOptimized();
        return opt == this.rootIdentifier ? this : new DOMDataTreeIdentifier(this.datastoreType, opt);
    }

    public int hashCode() {
        return this.datastoreType.hashCode() * 31 + this.rootIdentifier.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof DOMDataTreeIdentifier)) return false;
        DOMDataTreeIdentifier other = (DOMDataTreeIdentifier)obj;
        if (this.datastoreType != other.datastoreType) return false;
        if (!this.rootIdentifier.equals((Object)other.rootIdentifier)) return false;
        return true;
    }

    @Override
    public int compareTo(DOMDataTreeIdentifier domDataTreeIdentifier) {
        int cmp = this.datastoreType.compareTo((Enum)domDataTreeIdentifier.datastoreType);
        if (cmp != 0) {
            return cmp;
        }
        Iterator myIter = this.rootIdentifier.getPathArguments().iterator();
        Iterator otherIter = domDataTreeIdentifier.rootIdentifier.getPathArguments().iterator();
        while (myIter.hasNext()) {
            YangInstanceIdentifier.PathArgument otherPathArg;
            if (!otherIter.hasNext()) {
                return 1;
            }
            YangInstanceIdentifier.PathArgument myPathArg = (YangInstanceIdentifier.PathArgument)myIter.next();
            cmp = myPathArg.compareTo((Object)(otherPathArg = (YangInstanceIdentifier.PathArgument)otherIter.next()));
            if (cmp == 0) continue;
            return cmp;
        }
        return otherIter.hasNext() ? -1 : 0;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("datastore", (Object)this.datastoreType).add("root", (Object)this.rootIdentifier).toString();
    }
}

