/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.api;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

@NonNullByDefault
public abstract class DOMRpcIdentifier {
    private final QName type;

    private DOMRpcIdentifier(QName type) {
        this.type = Objects.requireNonNull(type);
    }

    public static DOMRpcIdentifier create(QName type) {
        return new Global(type);
    }

    public static DOMRpcIdentifier create(QName type, @Nullable YangInstanceIdentifier contextReference) {
        if (contextReference == null || contextReference.isEmpty()) {
            return new Global(type);
        }
        return new Local(type, contextReference);
    }

    public final QName getType() {
        return this.type;
    }

    public abstract YangInstanceIdentifier getContextReference();

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.type.hashCode();
        result = 31 * result + Objects.hashCode(this.getContextReference());
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(@Nullable Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof DOMRpcIdentifier)) return false;
        DOMRpcIdentifier other = (DOMRpcIdentifier)obj;
        if (!this.type.equals((Object)other.type)) return false;
        if (!Objects.equals(this.getContextReference(), other.getContextReference())) return false;
        return true;
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("type", (Object)this.type).add("contextReference", (Object)this.getContextReference()).toString();
    }

    private static final class Global
    extends DOMRpcIdentifier {
        private Global(QName type) {
            super(type);
        }

        @Override
        public YangInstanceIdentifier getContextReference() {
            return YangInstanceIdentifier.empty();
        }
    }

    private static final class Local
    extends DOMRpcIdentifier {
        private final YangInstanceIdentifier contextReference;

        private Local(QName type, YangInstanceIdentifier contextReference) {
            super(type);
            this.contextReference = Objects.requireNonNull(contextReference);
        }

        @Override
        public YangInstanceIdentifier getContextReference() {
            return this.contextReference;
        }
    }
}

