/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.api;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.ForwardingOnCommitFutureCallback;
import org.opendaylight.mdsal.common.api.OnCommitCallback;
import org.opendaylight.mdsal.common.api.OnCommitFutureCallback;
import org.opendaylight.mdsal.dom.api.DOMDataTreeTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteOperations;

public interface DOMDataTreeWriteTransaction
extends DOMDataTreeTransaction,
DOMDataTreeWriteOperations {
    @CheckReturnValue
    public @NonNull FluentFuture<? extends @NonNull CommitInfo> commit();

    default public void commit(@NonNull OnCommitCallback callback, @NonNull Executor executor) {
        ForwardingOnCommitFutureCallback forwardingOnCommitFutureCallback;
        if (callback instanceof OnCommitFutureCallback) {
            OnCommitFutureCallback onCommit = (OnCommitFutureCallback)callback;
            forwardingOnCommitFutureCallback = onCommit;
        } else {
            forwardingOnCommitFutureCallback = new ForwardingOnCommitFutureCallback(callback);
        }
        ForwardingOnCommitFutureCallback futureCallback = forwardingOnCommitFutureCallback;
        Objects.requireNonNull(executor);
        this.commit().addCallback((FutureCallback)futureCallback, executor);
    }

    public boolean cancel();
}

