/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.api;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.Executor;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionFactory;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.common.Empty;

public interface DOMTransactionChain
extends Registration,
DOMTransactionFactory {
    @Override
    public DOMDataTreeReadTransaction newReadOnlyTransaction();

    @Override
    public DOMDataTreeWriteTransaction newWriteOnlyTransaction();

    @Override
    public DOMDataTreeReadWriteTransaction newReadWriteTransaction();

    default public void addCallback(FutureCallback<Empty> callback) {
        this.addCallback(callback, MoreExecutors.directExecutor());
    }

    default public void addCallback(FutureCallback<Empty> callback, Executor executor) {
        Futures.addCallback(this.future(), callback, (Executor)executor);
    }

    public @NonNull ListenableFuture<Empty> future();
}

