/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.api;

import com.google.common.base.MoreObjects;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.common.api.LogicalDatastorePath;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DTIv1;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

@NonNullByDefault
public final class DOMDataTreeIdentifier
implements LogicalDatastorePath<DOMDataTreeIdentifier, YangInstanceIdentifier>,
Comparable<DOMDataTreeIdentifier> {
    private static final long serialVersionUID = 1L;
    private final YangInstanceIdentifier rootIdentifier;
    private final LogicalDatastoreType datastoreType;

    private DOMDataTreeIdentifier(LogicalDatastoreType datastore, YangInstanceIdentifier path) {
        this.datastoreType = Objects.requireNonNull(datastore);
        this.rootIdentifier = Objects.requireNonNull(path);
    }

    public static DOMDataTreeIdentifier of(LogicalDatastoreType datastore, YangInstanceIdentifier path) {
        return new DOMDataTreeIdentifier(datastore, path);
    }

    public LogicalDatastoreType datastore() {
        return this.datastoreType;
    }

    @Deprecated(since="13.0.0", forRemoval=true)
    public LogicalDatastoreType getDatastoreType() {
        return this.datastore();
    }

    public YangInstanceIdentifier path() {
        return this.rootIdentifier;
    }

    @Deprecated(since="13.0.0", forRemoval=true)
    public YangInstanceIdentifier getRootIdentifier() {
        return this.path();
    }

    public DOMDataTreeIdentifier toOptimized() {
        YangInstanceIdentifier opt = this.rootIdentifier.toOptimized();
        return opt == this.rootIdentifier ? this : DOMDataTreeIdentifier.of(this.datastoreType, opt);
    }

    @Override
    public int compareTo(DOMDataTreeIdentifier domDataTreeIdentifier) {
        int cmp = this.datastoreType.compareTo((Enum)domDataTreeIdentifier.datastoreType);
        if (cmp != 0) {
            return cmp;
        }
        Iterator myIter = this.rootIdentifier.getPathArguments().iterator();
        Iterator otherIter = domDataTreeIdentifier.rootIdentifier.getPathArguments().iterator();
        while (myIter.hasNext()) {
            YangInstanceIdentifier.PathArgument otherPathArg;
            if (!otherIter.hasNext()) {
                return 1;
            }
            YangInstanceIdentifier.PathArgument myPathArg = (YangInstanceIdentifier.PathArgument)myIter.next();
            cmp = myPathArg.compareTo(otherPathArg = (YangInstanceIdentifier.PathArgument)otherIter.next());
            if (cmp == 0) continue;
            return cmp;
        }
        return otherIter.hasNext() ? -1 : 0;
    }

    public int hashCode() {
        return this.datastoreType.hashCode() * 31 + this.rootIdentifier.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof DOMDataTreeIdentifier)) return false;
        DOMDataTreeIdentifier other = (DOMDataTreeIdentifier)obj;
        if (this.datastoreType != other.datastoreType) return false;
        if (!this.rootIdentifier.equals((Object)other.rootIdentifier)) return false;
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("datastore", (Object)this.datastoreType).add("root", (Object)this.rootIdentifier).toString();
    }

    Object writeReplace() {
        return new DTIv1(this);
    }
}

