/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.dom.broker.AbstractDOMRoutingTableEntry;
import org.opendaylight.mdsal.dom.broker.DOMActionRoutingTable;
import org.opendaylight.mdsal.dom.broker.DOMRpcRoutingTable;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

abstract sealed class AbstractDOMRoutingTable<I, D, M, L, K, E extends AbstractDOMRoutingTableEntry<D, M, L, K>>
permits DOMActionRoutingTable, DOMRpcRoutingTable {
    private final Map<K, E> operations;
    private final EffectiveModelContext schemaContext;

    AbstractDOMRoutingTable(Map<K, E> operations, EffectiveModelContext schemaContext) {
        this.operations = Objects.requireNonNull(operations);
        this.schemaContext = schemaContext;
    }

    final AbstractDOMRoutingTable<I, D, M, L, K, E> setSchemaContext(EffectiveModelContext context) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<K, E> oper : this.operations.entrySet()) {
            E entry = this.createOperationEntry(context, oper.getKey(), ((AbstractDOMRoutingTableEntry)oper.getValue()).getImplementations());
            if (entry == null) continue;
            builder.put(oper.getKey(), entry);
        }
        return this.newInstance((Map<K, E>)builder.build(), context);
    }

    final AbstractDOMRoutingTable<I, D, M, L, K, E> add(M implementation, Set<I> oprsToAdd) {
        if (oprsToAdd.isEmpty()) {
            return this;
        }
        ListMultimap<K, D> toAdd = this.decomposeIdentifiers(oprsToAdd);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<K, E> entry : this.operations.entrySet()) {
            ArrayList newOperations = new ArrayList(toAdd.removeAll(entry.getKey()));
            if (!newOperations.isEmpty()) {
                AbstractDOMRoutingTableEntry ne = ((AbstractDOMRoutingTableEntry)entry.getValue()).add(implementation, newOperations);
                builder.put(entry.getKey(), ne);
                continue;
            }
            builder.put(entry);
        }
        for (Map.Entry<K, Object> entry : toAdd.asMap().entrySet()) {
            ImmutableMap.Builder vb = ImmutableMap.builder();
            ImmutableList v = ImmutableList.of(implementation);
            for (Object i : (Collection)entry.getValue()) {
                vb.put(i, (Object)v);
            }
            E entry2 = this.createOperationEntry(this.schemaContext, entry.getKey(), (Map<D, List<M>>)vb.build());
            if (entry2 == null) continue;
            builder.put(entry.getKey(), entry2);
        }
        return this.newInstance((Map<K, E>)builder.build(), this.schemaContext);
    }

    final AbstractDOMRoutingTable<I, D, M, L, K, E> addAll(ImmutableTable<K, D, M> impls) {
        if (impls.isEmpty()) {
            return this;
        }
        HashBasedTable toAdd = HashBasedTable.create(impls);
        ImmutableMap.Builder mb = ImmutableMap.builder();
        for (Map.Entry<K, E> entry : this.operations.entrySet()) {
            Map newImpls = (Map)toAdd.rowMap().remove(entry.getKey());
            if (newImpls == null) {
                mb.put(entry);
                continue;
            }
            Map.Entry<K, Object> ne = entry;
            for (Map.Entry oper : newImpls.entrySet()) {
                AbstractDOMRoutingTableEntry newVal = ((AbstractDOMRoutingTableEntry)ne.getValue()).add(oper.getValue(), Lists.newArrayList((Object[])new Object[]{oper.getKey()}));
                ne = Map.entry(ne.getKey(), newVal);
            }
            mb.put(ne);
        }
        for (Map.Entry<K, Object> entry : toAdd.rowMap().entrySet()) {
            E entry2 = this.createOperationEntry(this.schemaContext, entry.getKey(), (Map<D, List<M>>)ImmutableMap.copyOf((Map)Maps.transformValues((Map)((Map)entry.getValue()), ImmutableList::of)));
            if (entry2 == null) continue;
            mb.put(entry.getKey(), entry2);
        }
        return this.newInstance((Map<K, E>)mb.build(), this.schemaContext);
    }

    final AbstractDOMRoutingTable<I, D, M, L, K, E> remove(M implementation, Set<I> instances) {
        if (instances.isEmpty()) {
            return this;
        }
        ListMultimap<K, D> toRemove = this.decomposeIdentifiers(instances);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<K, E> e : this.operations.entrySet()) {
            ArrayList removed = new ArrayList(toRemove.removeAll(e.getKey()));
            if (!removed.isEmpty()) {
                AbstractDOMRoutingTableEntry ne = ((AbstractDOMRoutingTableEntry)e.getValue()).remove(implementation, removed);
                if (ne == null) continue;
                builder.put(e.getKey(), ne);
                continue;
            }
            builder.put(e);
        }
        return this.newInstance((Map<K, E>)builder.build(), this.schemaContext);
    }

    final AbstractDOMRoutingTable<I, D, M, L, K, E> removeAll(ImmutableTable<K, D, M> impls) {
        if (impls.isEmpty()) {
            return this;
        }
        HashBasedTable toRemove = HashBasedTable.create(impls);
        ImmutableMap.Builder mb = ImmutableMap.builder();
        for (Map.Entry<K, E> re : this.operations.entrySet()) {
            Map oldImpls = (Map)toRemove.rowMap().remove(re.getKey());
            if (oldImpls == null) {
                mb.put(re);
                continue;
            }
            Map.Entry<K, Object> ne = re;
            for (Map.Entry oper : oldImpls.entrySet()) {
                if (ne == null) continue;
                AbstractDOMRoutingTableEntry newVal = ((AbstractDOMRoutingTableEntry)ne.getValue()).remove(oper.getValue(), Lists.newArrayList((Object[])new Object[]{oper.getKey()}));
                if (newVal != null) {
                    ne = Map.entry(ne.getKey(), newVal);
                    continue;
                }
                ne = null;
            }
            if (ne == null) continue;
            mb.put(ne);
        }
        return this.newInstance((Map<K, E>)mb.build(), this.schemaContext);
    }

    static final <K, V> HashMultimap<V, K> invertImplementationsMap(Map<K, V> map) {
        return (HashMultimap)Multimaps.invertFrom((Multimap)Multimaps.forMap(map), (Multimap)HashMultimap.create());
    }

    @VisibleForTesting
    final Map<K, Set<D>> getOperations() {
        return Maps.transformValues(this.operations, AbstractDOMRoutingTableEntry::registeredIdentifiers);
    }

    final Map<K, Set<D>> getOperations(L listener) {
        HashMap ret = new HashMap(this.operations.size());
        for (Map.Entry<K, E> e : this.operations.entrySet()) {
            Set ids = ((AbstractDOMRoutingTableEntry)e.getValue()).registeredIdentifiers(listener);
            if (ids.isEmpty()) continue;
            ret.put(e.getKey(), ids);
        }
        return ret;
    }

    final @Nullable AbstractDOMRoutingTableEntry<D, M, L, K> getEntry(@NonNull K type) {
        return (AbstractDOMRoutingTableEntry)this.operations.get(type);
    }

    protected abstract AbstractDOMRoutingTable<I, D, M, L, K, E> newInstance(Map<K, E> var1, EffectiveModelContext var2);

    abstract ListMultimap<K, D> decomposeIdentifiers(Set<I> var1);

    abstract @Nullable E createOperationEntry(EffectiveModelContext var1, K var2, Map<D, List<M>> var3);
}

