/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.mdsal.dom.broker.DOMActionRoutingTableEntry;
import org.opendaylight.mdsal.dom.broker.DOMRpcRoutingTableEntry;

abstract sealed class AbstractDOMRoutingTableEntry<D, M, L, K>
permits DOMActionRoutingTableEntry, DOMRpcRoutingTableEntry {
    private final Map<D, List<M>> implementations;
    private final K type;

    AbstractDOMRoutingTableEntry(K type, Map<D, List<M>> implementations) {
        this.type = Objects.requireNonNull(type);
        this.implementations = Objects.requireNonNull(implementations);
    }

    final K getType() {
        return this.type;
    }

    final List<M> getImplementations(D identifier) {
        return this.implementations.get(identifier);
    }

    final Map<D, List<M>> getImplementations() {
        return this.implementations;
    }

    @VisibleForTesting
    final Set<D> registeredIdentifiers() {
        return this.implementations.keySet();
    }

    protected abstract Set<D> registeredIdentifiers(L var1);

    final AbstractDOMRoutingTableEntry<D, M, L, K> add(M implementation, List<D> newOprs) {
        ImmutableMap.Builder vb = ImmutableMap.builder();
        for (Map.Entry<D, List<M>> entry : this.implementations.entrySet()) {
            if (newOprs.remove(entry.getKey())) {
                ArrayList<M> impls = new ArrayList<M>(entry.getValue().size() + 1);
                impls.addAll((Collection)entry.getValue());
                impls.add(implementation);
                impls.sort(this.implComparator());
                vb.put(entry.getKey(), impls);
                continue;
            }
            vb.put(entry);
        }
        for (Map.Entry<Object, List<Object>> ii : newOprs) {
            ArrayList<M> impl = new ArrayList<M>(1);
            impl.add(implementation);
            vb.put(ii, impl);
        }
        return this.newInstance((Map<D, List<M>>)vb.build());
    }

    final AbstractDOMRoutingTableEntry<D, M, L, K> remove(M implementation, List<D> removed) {
        ImmutableMap.Builder vb = ImmutableMap.builder();
        for (Map.Entry<D, List<M>> entry : this.implementations.entrySet()) {
            if (removed.remove(entry.getKey())) {
                ArrayList impls = new ArrayList(entry.getValue());
                impls.remove(implementation);
                if (impls.isEmpty()) continue;
                vb.put(entry.getKey(), impls);
                continue;
            }
            vb.put(entry);
        }
        ImmutableMap v = vb.build();
        return v.isEmpty() ? null : this.newInstance((Map<D, List<M>>)vb.build());
    }

    protected abstract Comparator<M> implComparator();

    protected abstract AbstractDOMRoutingTableEntry<D, M, L, K> newInstance(Map<D, List<M>> var1);
}

