/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMNotificationListener;
import org.opendaylight.mdsal.dom.api.DOMNotificationPublishDemandExtension;
import org.opendaylight.mdsal.dom.api.DOMNotificationPublishService;
import org.opendaylight.mdsal.dom.api.DOMNotificationService;
import org.opendaylight.mdsal.dom.broker.DOMNotificationRouterEvent;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.util.ObjectRegistry;
import org.opendaylight.yangtools.util.concurrent.EqualityQueuedNotificationManager;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(configurationPid={"org.opendaylight.mdsal.dom.notification"}, service={DOMNotificationRouter.class})
@Designate(ocd=Config.class)
public class DOMNotificationRouter
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DOMNotificationRouter.class);
    private final EqualityQueuedNotificationManager<Reg, DOMNotificationRouterEvent> queueNotificationManager;
    private final @NonNull DOMNotificationPublishService notificationPublishService = new PublishFacade();
    private final @NonNull DOMNotificationService notificationService = new SubscribeFacade();
    private final ObjectRegistry<DOMNotificationPublishDemandExtension.DemandListener> demandListeners = ObjectRegistry.createConcurrent((String)"notification demand listeners");
    private final ScheduledThreadPoolExecutor observer;
    private final ExecutorService executor;
    private volatile ImmutableMultimap<SchemaNodeIdentifier.Absolute, Reg> listeners = ImmutableMultimap.of();

    @Inject
    public DOMNotificationRouter(int maxQueueCapacity) {
        this.observer = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("DOMNotificationRouter-observer-%d").build());
        this.executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("DOMNotificationRouter-listeners-%d").build());
        this.queueNotificationManager = new EqualityQueuedNotificationManager("DOMNotificationRouter", (Executor)this.executor, maxQueueCapacity, DOMNotificationRouter::deliverEvents);
        LOG.info("DOM Notification Router started");
    }

    @Activate
    public DOMNotificationRouter(Config config) {
        this(config.queueDepth());
    }

    public @NonNull DOMNotificationService notificationService() {
        return this.notificationService;
    }

    public @NonNull DOMNotificationPublishService notificationPublishService() {
        return this.notificationPublishService;
    }

    private synchronized void removeRegistration(SingleReg reg) {
        this.replaceListeners((ImmutableMultimap<SchemaNodeIdentifier.Absolute, Reg>)ImmutableMultimap.copyOf((Multimap)Multimaps.filterValues(this.listeners, input -> input != reg)));
    }

    private synchronized void removeRegistrations(List<ComponentReg> regs) {
        this.replaceListeners((ImmutableMultimap<SchemaNodeIdentifier.Absolute, Reg>)ImmutableMultimap.copyOf((Multimap)Multimaps.filterValues(this.listeners, input -> !regs.contains(input))));
    }

    private void replaceListeners(ImmutableMultimap<SchemaNodeIdentifier.Absolute, Reg> newListeners) {
        this.listeners = newListeners;
        this.notifyListenerTypesChanged((ImmutableSet<SchemaNodeIdentifier.Absolute>)newListeners.keySet());
    }

    private void notifyListenerTypesChanged(@NonNull ImmutableSet<// Could not load outer class - annotation placement on inner may be incorrect
    SchemaNodeIdentifier.Absolute> typesAfter) {
        ImmutableList listenersAfter = (ImmutableList)this.demandListeners.streamObjects().collect(ImmutableList.toImmutableList());
        this.executor.execute(() -> {
            for (DOMNotificationPublishDemandExtension.DemandListener listener : listenersAfter) {
                try {
                    listener.onDemandUpdated(typesAfter);
                }
                catch (Exception e) {
                    LOG.warn("Uncaught exception during invoking listener {}", (Object)listener, (Object)e);
                }
            }
        });
    }

    @VisibleForTesting
    @NonNull ListenableFuture<? extends Object> putNotificationImpl(DOMNotification notification) throws InterruptedException {
        ImmutableCollection subscribers = this.listeners.get((Object)notification.getType());
        return subscribers.isEmpty() ? Empty.immediateFuture() : this.publish(notification, (Collection<Reg>)subscribers);
    }

    @VisibleForTesting
    @NonNull ListenableFuture<?> publish(DOMNotification notification, Collection<Reg> subscribers) {
        ArrayList futures = new ArrayList(subscribers.size());
        subscribers.forEach(subscriber -> {
            DOMNotificationRouterEvent event = new DOMNotificationRouterEvent(notification);
            futures.add(event.future());
            this.queueNotificationManager.submitNotification((Object)subscriber, (Object)event);
        });
        return Futures.transform((ListenableFuture)Futures.successfulAsList(futures), ignored -> Empty.value(), (Executor)MoreExecutors.directExecutor());
    }

    @Override
    @PreDestroy
    @Deactivate
    public void close() {
        this.observer.shutdown();
        this.executor.shutdown();
        LOG.info("DOM Notification Router stopped");
    }

    @VisibleForTesting
    ExecutorService executor() {
        return this.executor;
    }

    @VisibleForTesting
    ExecutorService observer() {
        return this.observer;
    }

    @VisibleForTesting
    ImmutableMultimap<SchemaNodeIdentifier.Absolute, ?> listeners() {
        return this.listeners;
    }

    @VisibleForTesting
    ObjectRegistry<DOMNotificationPublishDemandExtension.DemandListener> demandListeners() {
        return this.demandListeners;
    }

    private static void deliverEvents(Reg reg, ImmutableList<DOMNotificationRouterEvent> events) {
        if (reg.notClosed()) {
            DOMNotificationListener listener = reg.listener;
            for (DOMNotificationRouterEvent event : events) {
                event.deliverTo(listener);
            }
        } else {
            events.forEach(DOMNotificationRouterEvent::clear);
        }
    }

    private final class PublishFacade
    implements DOMNotificationPublishService,
    DOMNotificationPublishDemandExtension {
        private PublishFacade() {
        }

        public List<DOMNotificationPublishService.Extension> supportedExtensions() {
            return List.of(this);
        }

        public ListenableFuture<? extends Object> putNotification(DOMNotification notification) throws InterruptedException {
            return DOMNotificationRouter.this.putNotificationImpl(notification);
        }

        public ListenableFuture<? extends Object> offerNotification(DOMNotification notification) {
            ImmutableCollection subscribers = DOMNotificationRouter.this.listeners.get((Object)notification.getType());
            return subscribers.isEmpty() ? Empty.immediateFuture() : DOMNotificationRouter.this.publish(notification, (Collection<Reg>)subscribers);
        }

        public ListenableFuture<? extends Object> offerNotification(DOMNotification notification, long timeout, TimeUnit unit) throws InterruptedException {
            ImmutableCollection subscribers = DOMNotificationRouter.this.listeners.get((Object)notification.getType());
            if (subscribers.isEmpty()) {
                return Empty.immediateFuture();
            }
            ListenableFuture<?> noBlock = DOMNotificationRouter.this.publish(notification, (Collection<Reg>)subscribers);
            if (!DOMNotificationPublishService.REJECTED.equals(noBlock)) {
                return noBlock;
            }
            try {
                Thread publishThread = Thread.currentThread();
                ScheduledFuture<?> timerTask = DOMNotificationRouter.this.observer.schedule(publishThread::interrupt, timeout, unit);
                ListenableFuture<? extends Object> withBlock = DOMNotificationRouter.this.putNotificationImpl(notification);
                timerTask.cancel(true);
                if (DOMNotificationRouter.this.observer.getQueue().size() > 50) {
                    DOMNotificationRouter.this.observer.purge();
                }
                return withBlock;
            }
            catch (InterruptedException e) {
                return DOMNotificationPublishService.REJECTED;
            }
        }

        public Registration registerDemandListener(DOMNotificationPublishDemandExtension.DemandListener listener) {
            ImmutableSet initialTypes = DOMNotificationRouter.this.listeners.keySet();
            DOMNotificationRouter.this.executor.execute(() -> listener.onDemandUpdated(initialTypes));
            return DOMNotificationRouter.this.demandListeners.register((Object)listener);
        }
    }

    private final class SubscribeFacade
    implements DOMNotificationService {
        private SubscribeFacade() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Registration registerNotificationListener(DOMNotificationListener listener, Collection<SchemaNodeIdentifier.Absolute> types) {
            DOMNotificationRouter dOMNotificationRouter = DOMNotificationRouter.this;
            synchronized (dOMNotificationRouter) {
                SingleReg reg = new SingleReg(listener);
                if (!types.isEmpty()) {
                    ImmutableMultimap.Builder b = ImmutableMultimap.builder();
                    b.putAll(DOMNotificationRouter.this.listeners);
                    for (SchemaNodeIdentifier.Absolute t : types) {
                        b.put((Object)t, (Object)reg);
                    }
                    DOMNotificationRouter.this.replaceListeners((ImmutableMultimap<SchemaNodeIdentifier.Absolute, Reg>)b.build());
                }
                return reg;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Registration registerNotificationListeners(Map<SchemaNodeIdentifier.Absolute, DOMNotificationListener> typeToListener) {
            DOMNotificationRouter dOMNotificationRouter = DOMNotificationRouter.this;
            synchronized (dOMNotificationRouter) {
                ImmutableMultimap.Builder b = ImmutableMultimap.builder();
                b.putAll(DOMNotificationRouter.this.listeners);
                HashMap<DOMNotificationListener, ComponentReg> tmp = new HashMap<DOMNotificationListener, ComponentReg>();
                for (Map.Entry<SchemaNodeIdentifier.Absolute, DOMNotificationListener> e : typeToListener.entrySet()) {
                    b.put((Object)e.getKey(), (Object)tmp.computeIfAbsent(e.getValue(), ComponentReg::new));
                }
                DOMNotificationRouter.this.replaceListeners((ImmutableMultimap<SchemaNodeIdentifier.Absolute, Reg>)b.build());
                final List regs = List.copyOf(tmp.values());
                return new AbstractRegistration(){

                    protected void removeRegistration() {
                        regs.forEach(AbstractRegistration::close);
                        DOMNotificationRouter.this.removeRegistrations(regs);
                    }
                };
            }
        }
    }

    @ObjectClassDefinition
    public static @interface Config {
        @AttributeDefinition(name="notification-queue-depth")
        public int queueDepth() default 65536;
    }

    private final class SingleReg
    extends Reg {
        SingleReg(DOMNotificationListener listener) {
            super(listener);
        }

        protected void removeRegistration() {
            DOMNotificationRouter.this.removeRegistration(this);
        }
    }

    @VisibleForTesting
    static abstract sealed class Reg
    extends AbstractRegistration
    permits SingleReg, ComponentReg {
        private final @NonNull DOMNotificationListener listener;

        Reg(@NonNull DOMNotificationListener listener) {
            this.listener = Objects.requireNonNull(listener);
        }
    }

    private static final class ComponentReg
    extends Reg {
        ComponentReg(@NonNull DOMNotificationListener listener) {
            super(listener);
        }

        protected void removeRegistration() {
        }
    }
}

