/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi;

import com.google.common.annotations.Beta;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.EventListener;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.mdsal.dom.api.DOMSchemaServiceExtension;
import org.opendaylight.mdsal.dom.api.DOMYangTextSourceProvider;
import org.opendaylight.mdsal.dom.spi.AbstractDOMSchemaService;
import org.opendaylight.yangtools.concepts.NoOpListenerRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContextListener;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContextProvider;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.model.repo.spi.SchemaSourceProvider;

@Beta
public class FixedDOMSchemaService
extends AbstractDOMSchemaService {
    private final @NonNull EffectiveModelContextProvider schemaContextProvider;

    private FixedDOMSchemaService(EffectiveModelContextProvider schemaContextProvider) {
        this.schemaContextProvider = Objects.requireNonNull(schemaContextProvider);
    }

    public static @NonNull DOMSchemaService of(EffectiveModelContext effectiveModel) {
        EffectiveModelContext checked = Objects.requireNonNull(effectiveModel);
        return FixedDOMSchemaService.of(() -> checked);
    }

    public static @NonNull DOMSchemaService of(EffectiveModelContextProvider schemaContextProvider) {
        return new FixedDOMSchemaService(schemaContextProvider);
    }

    public static @NonNull DOMSchemaService of(EffectiveModelContextProvider schemaContextProvider, SchemaSourceProvider<YangTextSchemaSource> yangTextSourceProvider) {
        return new WithYangTextSources(schemaContextProvider, Objects.requireNonNull(yangTextSourceProvider));
    }

    public final EffectiveModelContext getGlobalContext() {
        return this.schemaContextProvider.getEffectiveModelContext();
    }

    public final Registration registerSchemaContextListener(EffectiveModelContextListener listener) {
        listener.onModelContextUpdated(this.getGlobalContext());
        return NoOpListenerRegistration.of((EventListener)listener);
    }

    private static final class WithYangTextSources
    extends FixedDOMSchemaService
    implements DOMYangTextSourceProvider {
        private final @NonNull SchemaSourceProvider<YangTextSchemaSource> schemaSourceProvider;

        WithYangTextSources(EffectiveModelContextProvider schemaContextProvider, SchemaSourceProvider<YangTextSchemaSource> schemaSourceProvider) {
            super(schemaContextProvider);
            this.schemaSourceProvider = Objects.requireNonNull(schemaSourceProvider);
        }

        public ClassToInstanceMap<DOMSchemaServiceExtension> getExtensions() {
            return ImmutableClassToInstanceMap.of(DOMYangTextSourceProvider.class, (Object)this);
        }

        public ListenableFuture<? extends YangTextSchemaSource> getSource(SourceIdentifier sourceIdentifier) {
            return this.schemaSourceProvider.getSource(sourceIdentifier);
        }
    }
}

